/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class InputEntityStream
extends FilterInputStream {
    private volatile long availableSize;
    private volatile long markedAvailableSize;

    public InputEntityStream(InputStream source, long size) {
        super(source);
        this.availableSize = size;
        this.markedAvailableSize = -1L;
    }

    public int available() throws IOException {
        return Math.min((int)this.availableSize, super.available());
    }

    public void close() throws IOException {
    }

    public synchronized void mark(int readlimit) {
        if (this.markSupported()) {
            this.markedAvailableSize = this.availableSize;
        }
        super.mark(readlimit);
    }

    public int read() throws IOException {
        int result = -1;
        if (this.availableSize > 0L && (result = this.in.read()) != -1) {
            --this.availableSize;
        }
        return result;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int result = -1;
        if (this.availableSize > 0L && (result = this.in.read(b, off, Math.min(len, (int)this.availableSize))) > 0) {
            this.availableSize -= (long)result;
        }
        return result;
    }

    public synchronized void reset() throws IOException {
        if (this.markSupported() && this.markedAvailableSize != -1L) {
            this.availableSize = this.markedAvailableSize;
            this.markedAvailableSize = -1L;
        }
        super.reset();
    }
}

