/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.security;

import org.restlet.Request;
import org.restlet.Response;
import org.restlet.security.UserPrincipal;
import org.restlet.security.Verifier;

public abstract class SecretVerifier
extends Verifier {
    public static boolean compare(char[] secret1, char[] secret2) {
        boolean result = false;
        if (secret1 == null || secret2 == null) {
            result = secret1 == secret2;
        } else if (secret1.length == secret2.length) {
            boolean equals = true;
            for (int i = 0; i < secret1.length && equals; ++i) {
                equals = secret1[i] == secret2[i];
            }
            result = equals;
        }
        return result;
    }

    protected UserPrincipal createUserPrincipal(String identifier) {
        return new UserPrincipal(identifier);
    }

    public int verify(Request request, Response response) {
        int result = 4;
        if (request.getChallengeResponse() == null) {
            result = 0;
        } else {
            char[] inputSecret;
            String identifier = request.getChallengeResponse().getIdentifier();
            if (this.verify(identifier, inputSecret = request.getChallengeResponse().getSecret())) {
                if (request.getClientInfo().getSubject() != null) {
                    request.getClientInfo().getSubject().getPrincipals().add(this.createUserPrincipal(identifier));
                }
            } else {
                result = -1;
            }
        }
        return result;
    }

    public abstract boolean verify(String var1, char[] var2);
}

