/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.security;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.restlet.security.Group;
import org.restlet.security.User;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Organization {
    private volatile String description;
    private volatile String domainName;
    private volatile String name;
    private final List<Group> rootGroups;
    private final List<User> users;

    public Organization() {
        this(null, null, null);
    }

    public Organization(String name, String description, String domainName) {
        this.name = name;
        this.description = description;
        this.domainName = domainName;
        this.rootGroups = new CopyOnWriteArrayList<Group>();
        this.users = new CopyOnWriteArrayList<User>();
    }

    private void addGroups(User user, Set<Group> userGroups, Group currentGroup, List<Group> stack, boolean inheritOnly) {
        if (currentGroup != null && !stack.contains(currentGroup)) {
            stack.add(currentGroup);
            if (currentGroup.getMemberUsers().contains(user)) {
                userGroups.add(currentGroup);
                boolean inherit = !inheritOnly || currentGroup.isInheritRoles();
                for (int i = stack.size() - 2; inherit && i >= 0; --i) {
                    Group group = stack.get(i);
                    userGroups.add(group);
                    inherit = !inheritOnly || group.isInheritRoles();
                }
            }
            for (Group group : currentGroup.getMemberGroups()) {
                this.addGroups(user, userGroups, group, stack, inheritOnly);
            }
        }
    }

    public Set<Group> findGroups(User user) {
        return this.findGroups(user, true);
    }

    public Set<Group> findGroups(User user, boolean inheritOnly) {
        HashSet<Group> result = new HashSet<Group>();
        for (Group group : this.getRootGroups()) {
            ArrayList<Group> stack = new ArrayList<Group>();
            this.addGroups(user, result, group, stack, inheritOnly);
        }
        return result;
    }

    public User findUser(String userIdentifier) {
        User result = null;
        for (int i = 0; result == null && i < this.getUsers().size(); ++i) {
            User user = this.getUsers().get(i);
            if (!user.getIdentifier().equals(userIdentifier)) continue;
            result = user;
        }
        return result;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getName() {
        return this.name;
    }

    public List<Group> getRootGroups() {
        return this.rootGroups;
    }

    public List<User> getUsers() {
        return this.users;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public synchronized void setRootGroups(List<Group> rootGroups) {
        this.rootGroups.clear();
        if (rootGroups != null) {
            this.rootGroups.addAll(rootGroups);
        }
    }

    public synchronized void setUsers(List<User> users) {
        this.users.clear();
        if (users != null) {
            this.users.addAll(users);
        }
    }

    public String toString() {
        return this.getName();
    }
}

