/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.security;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.restlet.security.User;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Group {
    private volatile String description;
    private volatile boolean inheritRoles;
    private final List<Group> memberGroups;
    private final List<User> memberUsers;
    private volatile String name;

    public Group() {
        this(null, null);
    }

    public Group(String name, String description) {
        this(name, description, true);
    }

    public Group(String name, String description, boolean inheritRoles) {
        this.name = name;
        this.description = description;
        this.inheritRoles = inheritRoles;
        this.memberGroups = new CopyOnWriteArrayList<Group>();
        this.memberUsers = new CopyOnWriteArrayList<User>();
    }

    public String getDescription() {
        return this.description;
    }

    public List<Group> getMemberGroups() {
        return this.memberGroups;
    }

    public List<User> getMemberUsers() {
        return this.memberUsers;
    }

    public String getName() {
        return this.name;
    }

    public boolean isInheritRoles() {
        return this.inheritRoles;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setInheritRoles(boolean inheritPermissions) {
        this.inheritRoles = inheritPermissions;
    }

    public void setMemberGroups(List<Group> memberGroups) {
        this.memberGroups.clear();
        if (memberGroups != null) {
            this.memberGroups.addAll(memberGroups);
        }
    }

    public void setMemberUsers(List<User> memberUsers) {
        this.memberUsers.clear();
        if (memberUsers != null) {
            this.memberUsers.addAll(memberUsers);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.getName();
    }
}

