/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.routing;

import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.Status;
import org.restlet.resource.Finder;
import org.restlet.routing.Route;
import org.restlet.util.RouteList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Router
extends Restlet {
    public static final int BEST = 1;
    public static final int CUSTOM = 6;
    public static final int FIRST = 2;
    public static final int LAST = 3;
    public static final int NEXT = 4;
    public static final int RANDOM = 5;
    private volatile int defaultMatchingMode = 1;
    private volatile boolean defaultMatchQuery = true;
    private volatile Route defaultRoute = null;
    private volatile Class<? extends Finder> finderClass = Finder.class;
    private volatile int maxAttempts = 1;
    private volatile float requiredScore = 0.5f;
    private volatile long retryDelay = 500L;
    private volatile RouteList routes = new RouteList();
    private volatile int routingMode = 1;

    public Router() {
        this(null);
    }

    public Router(Context context) {
        super(context);
    }

    public Route attach(Restlet target) {
        return this.attach("", target);
    }

    public Route attach(String pathTemplate, Class<?> targetClass) {
        return this.attach(pathTemplate, this.createFinder(targetClass));
    }

    public Route attach(String pathTemplate, Restlet target) {
        Route result = this.createRoute(pathTemplate, target);
        this.getRoutes().add(result);
        return result;
    }

    public Route attachDefault(Class<?> defaultTargetClass) {
        return this.attachDefault(this.createFinder(defaultTargetClass));
    }

    public Route attachDefault(Restlet defaultTarget) {
        Route result = this.createRoute("", defaultTarget);
        this.setDefaultRoute(result);
        return result;
    }

    public Finder createFinder(Class<?> targetClass) {
        return Finder.createFinder(targetClass, this.getFinderClass(), this.getContext(), this.getLogger());
    }

    protected Route createRoute(String uriPattern, Restlet target) {
        Route result = new Route(this, uriPattern, target);
        result.getTemplate().setMatchingMode(this.getDefaultMatchingMode());
        result.setMatchQuery(this.defaultMatchQuery);
        return result;
    }

    public void detach(Restlet target) {
        this.getRoutes().removeAll(target);
        if (this.getDefaultRoute() != null && this.getDefaultRoute().getNext() == target) {
            this.setDefaultRoute(null);
        }
    }

    protected void doHandle(Restlet next, Request request, Response response) {
        next.handle(request, response);
    }

    protected Route getCustom(Request request, Response response) {
        return null;
    }

    public int getDefaultMatchingMode() {
        return this.defaultMatchingMode;
    }

    public boolean getDefaultMatchQuery() {
        return this.defaultMatchQuery;
    }

    public Route getDefaultRoute() {
        return this.defaultRoute;
    }

    public Class<? extends Finder> getFinderClass() {
        return this.finderClass;
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public Restlet getNext(Request request, Response response) {
        Route result = null;
        block10: for (int i = 0; result == null && i < this.getMaxAttempts(); ++i) {
            if (i > 0) {
                try {
                    Thread.sleep(this.getRetryDelay());
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if (this.routes == null) continue;
            switch (this.getRoutingMode()) {
                case 1: {
                    result = this.getRoutes().getBest(request, response, this.getRequiredScore());
                    continue block10;
                }
                case 2: {
                    result = this.getRoutes().getFirst(request, response, this.getRequiredScore());
                    continue block10;
                }
                case 3: {
                    result = this.getRoutes().getLast(request, response, this.getRequiredScore());
                    continue block10;
                }
                case 4: {
                    result = this.getRoutes().getNext(request, response, this.getRequiredScore());
                    continue block10;
                }
                case 5: {
                    result = this.getRoutes().getRandom(request, response, this.getRequiredScore());
                    continue block10;
                }
                case 6: {
                    result = this.getCustom(request, response);
                }
            }
        }
        if (result == null) {
            if (this.getDefaultRoute() != null && this.getDefaultRoute().score(request, response) >= this.getRequiredScore()) {
                result = this.getDefaultRoute();
            } else {
                response.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
            }
        }
        this.logRoute(result);
        return result;
    }

    public float getRequiredScore() {
        return this.requiredScore;
    }

    public long getRetryDelay() {
        return this.retryDelay;
    }

    public RouteList getRoutes() {
        return this.routes;
    }

    public int getRoutingMode() {
        return this.routingMode;
    }

    @Override
    public void handle(Request request, Response response) {
        super.handle(request, response);
        Restlet next = this.getNext(request, response);
        if (next != null) {
            this.doHandle(next, request, response);
        } else {
            response.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
        }
    }

    protected void logRoute(Route route) {
        if (this.getLogger().isLoggable(Level.FINE)) {
            if (this.getDefaultRoute() == route) {
                this.getLogger().fine("The default route was selected.");
            } else {
                this.getLogger().fine("This route was selected: \"" + route + "\"");
            }
        }
    }

    public void setDefaultMatchingMode(int defaultMatchingMode) {
        this.defaultMatchingMode = defaultMatchingMode;
    }

    public void setDefaultMatchQuery(boolean defaultMatchQuery) {
        this.defaultMatchQuery = defaultMatchQuery;
    }

    public void setDefaultRoute(Route defaultRoute) {
        this.defaultRoute = defaultRoute;
    }

    public void setFinderClass(Class<? extends Finder> finderClass) {
        this.finderClass = finderClass;
    }

    public void setMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    public void setRequiredScore(float score) {
        this.requiredScore = score;
    }

    public void setRetryDelay(long retryDelay) {
        this.retryDelay = retryDelay;
    }

    public void setRoutes(RouteList routes) {
        this.routes = routes;
    }

    public void setRoutingMode(int routingMode) {
        this.routingMode = routingMode;
    }
}

