/*
 * Decompiled with CFR 0.152.
 */
package org.restlet;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.engine.Engine;
import org.restlet.engine.RestletHelper;
import org.restlet.engine.application.ApplicationHelper;
import org.restlet.engine.resource.AnnotationUtils;
import org.restlet.resource.Finder;
import org.restlet.security.Role;
import org.restlet.service.ConnectorService;
import org.restlet.service.ConverterService;
import org.restlet.service.DecoderService;
import org.restlet.service.MetadataService;
import org.restlet.service.RangeService;
import org.restlet.service.Service;
import org.restlet.service.StatusService;
import org.restlet.service.TaskService;
import org.restlet.service.TunnelService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Application
extends Restlet {
    private static final ThreadLocal<Application> CURRENT = new ThreadLocal();
    private volatile Class<? extends Finder> finderClass;
    private volatile RestletHelper<Application> helper;
    private final List<Role> roles;
    private volatile Restlet inboundRoot;
    private volatile Restlet outboundRoot;
    private final List<Service> services;

    public static Application getCurrent() {
        return CURRENT.get();
    }

    public static void setCurrent(Application application) {
        CURRENT.set(application);
    }

    public Application() {
        this(null);
    }

    public Application(Context context) {
        super(context);
        if (Engine.getInstance() != null) {
            this.helper = new ApplicationHelper(this);
        }
        this.roles = new CopyOnWriteArrayList<Role>();
        this.outboundRoot = null;
        this.inboundRoot = null;
        this.services = new CopyOnWriteArrayList<Service>();
        this.services.add(new TunnelService(true, true));
        this.services.add(new StatusService());
        this.services.add(new DecoderService());
        this.services.add(new RangeService());
        this.services.add(new ConnectorService());
        this.services.add(new ConverterService());
        this.services.add(new MetadataService());
        this.services.add(new TaskService());
    }

    public Restlet createInboundRoot() {
        return null;
    }

    public Restlet createOutboundRoot() {
        return this.getContext() != null ? this.getContext().getClientDispatcher() : null;
    }

    @Deprecated
    public Restlet createRoot() {
        return this.createInboundRoot();
    }

    public ConnectorService getConnectorService() {
        return this.getService(ConnectorService.class);
    }

    public ConverterService getConverterService() {
        return this.getService(ConverterService.class);
    }

    public DecoderService getDecoderService() {
        return this.getService(DecoderService.class);
    }

    public Class<? extends Finder> getFinderClass() {
        return this.finderClass;
    }

    private RestletHelper<Application> getHelper() {
        return this.helper;
    }

    public synchronized Restlet getInboundRoot() {
        if (this.inboundRoot == null) {
            this.inboundRoot = this.createInboundRoot();
        }
        return this.inboundRoot;
    }

    public MetadataService getMetadataService() {
        return this.getService(MetadataService.class);
    }

    public synchronized Restlet getOutboundRoot() {
        if (this.outboundRoot == null) {
            this.outboundRoot = this.createOutboundRoot();
        }
        return this.outboundRoot;
    }

    public RangeService getRangeService() {
        return this.getService(RangeService.class);
    }

    public Role getRole(String name) {
        for (Role role : this.getRoles()) {
            if (!role.getName().equals(name)) continue;
            return role;
        }
        return null;
    }

    public List<Role> getRoles() {
        return this.roles;
    }

    @Deprecated
    public synchronized Restlet getRoot() {
        return this.getInboundRoot();
    }

    public <T extends Service> T getService(Class<T> clazz) {
        for (Service service : this.getServices()) {
            if (!clazz.isAssignableFrom(service.getClass())) continue;
            return (T)service;
        }
        return null;
    }

    public List<Service> getServices() {
        return this.services;
    }

    public StatusService getStatusService() {
        return this.getService(StatusService.class);
    }

    public TaskService getTaskService() {
        return this.getService(TaskService.class);
    }

    public TunnelService getTunnelService() {
        return this.getService(TunnelService.class);
    }

    @Override
    public void handle(Request request, Response response) {
        super.handle(request, response);
        if (this.getHelper() != null) {
            this.getHelper().handle(request, response);
        }
    }

    public synchronized void setClientRoot(Class<?> clientRootClass) {
        this.setOutboundRoot(Finder.createFinder(clientRootClass, this.getFinderClass(), this.getContext(), this.getLogger()));
    }

    public void setConnectorService(ConnectorService connectorService) {
        this.setService(connectorService);
    }

    public void setConverterService(ConverterService converterService) {
        this.setService(converterService);
    }

    public void setDecoderService(DecoderService decoderService) {
        this.setService(decoderService);
    }

    public void setFinderClass(Class<? extends Finder> finderClass) {
        this.finderClass = finderClass;
    }

    public synchronized void setInboundRoot(Class<?> inboundRootClass) {
        this.setInboundRoot(Finder.createFinder(inboundRootClass, this.getFinderClass(), this.getContext(), this.getLogger()));
    }

    public synchronized void setInboundRoot(Restlet inboundRoot) {
        this.inboundRoot = inboundRoot;
    }

    public void setMetadataService(MetadataService metadataService) {
        this.setService(metadataService);
    }

    public synchronized void setOutboundRoot(Restlet outboundRoot) {
        this.outboundRoot = outboundRoot;
    }

    public void setRangeService(RangeService rangeService) {
        this.setService(rangeService);
    }

    public void setRoles(List<Role> roles) {
        this.roles.clear();
        if (roles != null) {
            this.roles.addAll(roles);
        }
    }

    @Deprecated
    public synchronized void setRoot(Class<?> inboundRootClass) {
        this.setInboundRoot(inboundRootClass);
    }

    @Deprecated
    public synchronized void setRoot(Restlet inboundRoot) {
        this.setInboundRoot(inboundRoot);
    }

    protected synchronized void setService(Service newService) {
        CopyOnWriteArrayList<Service> services = new CopyOnWriteArrayList<Service>();
        boolean replaced = false;
        for (int i = 0; i < this.services.size(); ++i) {
            Service service = this.services.get(i);
            if (service == null) continue;
            if (service.getClass().isAssignableFrom(newService.getClass())) {
                try {
                    service.stop();
                }
                catch (Exception e) {
                    this.getLogger().log(Level.WARNING, "Unable to stop service replaced", e);
                }
                services.add(newService);
                replaced = true;
                continue;
            }
            services.add(service);
        }
        if (!replaced) {
            services.add(newService);
        }
        this.setServices(services);
    }

    public synchronized void setServices(List<Service> services) {
        this.services.clear();
        if (services != null) {
            this.services.addAll(services);
        }
    }

    public void setStatusService(StatusService statusService) {
        this.setService(statusService);
    }

    public void setTaskService(TaskService taskService) {
        this.setService(taskService);
    }

    public void setTunnelService(TunnelService tunnelService) {
        this.setService(tunnelService);
    }

    @Override
    public synchronized void start() throws Exception {
        if (this.isStopped()) {
            super.start();
            if (this.getHelper() != null) {
                this.getHelper().start();
            }
            for (Service service : this.getServices()) {
                service.start();
            }
        }
    }

    @Override
    public synchronized void stop() throws Exception {
        if (this.isStarted()) {
            for (Service service : this.getServices()) {
                service.stop();
            }
            if (this.getHelper() != null) {
                this.getHelper().stop();
            }
            AnnotationUtils.clearCache();
            super.stop();
        }
    }
}

