/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.routing;

import java.util.logging.Level;
import org.restlet.Restlet;
import org.restlet.data.Reference;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.routing.Filter;
import org.restlet.routing.Router;
import org.restlet.util.Template;

public class TemplateRoute
extends Filter {
    private volatile boolean matchQuery;
    private volatile Router router;
    private volatile Template template;

    public TemplateRoute(Restlet next) {
        this(null, (Template)null, next);
    }

    public TemplateRoute(Router router, String uriTemplate, Restlet next) {
        this(router, new Template(uriTemplate, 1, 14, "", true, false), next);
    }

    public TemplateRoute(Router router, Template template, Restlet next) {
        super(router == null ? null : router.getContext(), next);
        this.matchQuery = router == null ? true : router.getDefaultMatchQuery();
        this.router = router;
        this.template = template;
    }

    protected int beforeHandle(Request request, Response response) {
        if (this.getTemplate() != null) {
            String remainingPart = request.getResourceRef().getRemainingPart(false, this.getMatchQuery());
            int matchedLength = this.getTemplate().parse(remainingPart, request);
            if (this.getLogger().isLoggable(Level.FINER)) {
                this.getLogger().finer("Attempting to match this pattern: " + this.getTemplate().getPattern() + " >> " + matchedLength);
            }
            if (matchedLength != -1) {
                String matchedPart = remainingPart.substring(0, matchedLength);
                Reference baseRef = request.getResourceRef().getBaseRef();
                baseRef = baseRef == null ? new Reference(matchedPart) : new Reference(baseRef.toString(false, false) + matchedPart);
                request.getResourceRef().setBaseRef(baseRef);
                if (this.getLogger().isLoggable(Level.FINE)) {
                    this.getLogger().fine("New base URI: " + request.getResourceRef().getBaseRef());
                    this.getLogger().fine("New remaining part: " + request.getResourceRef().getRemainingPart(false, this.getMatchQuery()));
                }
                if (this.getLogger().isLoggable(Level.FINE)) {
                    this.getLogger().fine("Delegating the call to the target Restlet");
                }
            } else {
                response.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
            }
        }
        return 0;
    }

    public int getMatchingMode() {
        return this.getTemplate().getMatchingMode();
    }

    public boolean getMatchQuery() {
        return this.matchQuery;
    }

    public Router getRouter() {
        return this.router;
    }

    public Template getTemplate() {
        return this.template;
    }

    public float score(Request request, Response response) {
        float result = 0.0f;
        if (this.getRouter() != null && request.getResourceRef() != null && this.getTemplate() != null) {
            int matchedLength;
            String remainingPart = request.getResourceRef().getRemainingPart(false, this.getMatchQuery());
            if (remainingPart != null && (matchedLength = this.getTemplate().match(remainingPart)) != -1) {
                float totalLength = remainingPart.length();
                result = totalLength > 0.0f ? this.getRouter().getRequiredScore() + (1.0f - this.getRouter().getRequiredScore()) * ((float)matchedLength / totalLength) : 1.0f;
            }
            if (this.getLogger().isLoggable(Level.FINER)) {
                this.getLogger().finer("Call score for the \"" + this.getTemplate().getPattern() + "\" URI pattern: " + result);
            }
        }
        return result;
    }

    public void setMatchingMode(int matchingMode) {
        this.getTemplate().setMatchingMode(matchingMode);
    }

    public void setMatchQuery(boolean matchQuery) {
        this.matchQuery = matchQuery;
    }

    public void setRouter(Router router) {
        this.router = router;
    }

    public void setTemplate(Template template) {
        this.template = template;
    }

    public String toString() {
        return this.getTemplate() == null ? super.toString() : this.getTemplate().getPattern();
    }
}

