/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.representation;

import java.util.Date;
import org.restlet.data.MediaType;
import org.restlet.data.Tag;
import org.restlet.engine.util.DateUtils;
import org.restlet.representation.Variant;

public class RepresentationInfo
extends Variant {
    private volatile Date modificationDate;
    private volatile Tag tag;

    public RepresentationInfo() {
        this(null);
    }

    public RepresentationInfo(MediaType mediaType) {
        this(mediaType, null, null);
    }

    public RepresentationInfo(MediaType mediaType, Date modificationDate) {
        this(mediaType, modificationDate, null);
    }

    public RepresentationInfo(MediaType mediaType, Date modificationDate, Tag tag) {
        super(mediaType);
        this.modificationDate = modificationDate;
        this.tag = tag;
    }

    public RepresentationInfo(MediaType mediaType, Tag tag) {
        this(mediaType, null, tag);
    }

    public RepresentationInfo(Variant variant, Date modificationDate) {
        this(variant, modificationDate, null);
    }

    public RepresentationInfo(Variant variant, Date modificationDate, Tag tag) {
        this.setCharacterSet(variant.getCharacterSet());
        this.setEncodings(variant.getEncodings());
        this.setIdentifier(variant.getIdentifier());
        this.setLanguages(variant.getLanguages());
        this.setMediaType(variant.getMediaType());
        this.setModificationDate(modificationDate);
        this.setTag(tag);
    }

    public RepresentationInfo(Variant variant, Tag tag) {
        this(variant, null, tag);
    }

    public Date getModificationDate() {
        return this.modificationDate;
    }

    public Tag getTag() {
        return this.tag;
    }

    public void setModificationDate(Date modificationDate) {
        this.modificationDate = DateUtils.unmodifiable(modificationDate);
    }

    public void setTag(Tag tag) {
        this.tag = tag;
    }
}

