/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.security;

import java.util.Date;
import java.util.TreeMap;
import org.restlet.data.ChallengeRequest;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Form;
import org.restlet.data.Method;
import org.restlet.data.Parameter;
import org.restlet.data.Reference;
import org.restlet.data.Request;
import org.restlet.engine.security.AuthenticatorHelper;
import org.restlet.engine.util.Base64;
import org.restlet.engine.util.DateUtils;
import org.restlet.engine.util.DigestUtils;
import org.restlet.engine.util.SystemUtils;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpMsSharedKeyHelper
extends AuthenticatorHelper {
    private static String getCanonicalizedAzureHeaders(Series<Parameter> requestHeaders) {
        TreeMap<String, String> azureHeaders = new TreeMap<String, String>();
        for (Parameter param : requestHeaders) {
            String headerName = param.getName().toLowerCase();
            if (!headerName.startsWith("x-ms-") || azureHeaders.containsKey(headerName)) continue;
            azureHeaders.put(headerName, requestHeaders.getValues(headerName));
        }
        StringBuilder sb = new StringBuilder();
        for (String key : azureHeaders.keySet()) {
            sb.append(key).append(':').append((String)azureHeaders.get(key)).append("\n");
        }
        return sb.toString();
    }

    private static String getCanonicalizedResourceName(Reference resourceRef) {
        Form form = resourceRef.getQueryAsForm();
        Object param = form.getFirst("comp", true);
        if (param != null) {
            StringBuilder sb = new StringBuilder(resourceRef.getPath());
            return sb.append("?").append("comp=").append(((Parameter)param).getValue()).toString();
        }
        return resourceRef.getPath();
    }

    public HttpMsSharedKeyHelper() {
        super(ChallengeScheme.HTTP_MS_SHAREDKEY, true, false);
    }

    @Override
    public String format(ChallengeRequest request) {
        return null;
    }

    @Override
    public void formatCredentials(StringBuilder sb, ChallengeResponse challenge, Request request, Series<Parameter> httpHeaders) {
        String contentType;
        String contentMd5;
        String methodName = request.getMethod().getName();
        String date = "";
        if (httpHeaders.getFirstValue("x-ms-date", true) == null && (date = httpHeaders.getFirstValue("Date", true)) == null) {
            date = DateUtils.format(new Date(), DateUtils.FORMAT_RFC_1123.get(0));
            httpHeaders.add("Date", date);
        }
        if ((contentMd5 = httpHeaders.getFirstValue("Content-MD5", true)) == null) {
            contentMd5 = "";
        }
        if ((contentType = httpHeaders.getFirstValue("Content-Type", true)) == null) {
            boolean applyPatch = false;
            String jvmVendor = System.getProperty("java.vm.vendor");
            if (jvmVendor != null && jvmVendor.toLowerCase().startsWith("sun")) {
                int majorVersionNumber = SystemUtils.getJavaMajorVersion();
                int minorVersionNumber = SystemUtils.getJavaMinorVersion();
                if (majorVersionNumber == 1) {
                    if (minorVersionNumber < 5) {
                        applyPatch = true;
                    } else if (minorVersionNumber == 5) {
                        applyPatch = SystemUtils.getJavaUpdateVersion() < 10;
                    }
                }
            }
            contentType = applyPatch && !request.getMethod().equals(Method.PUT) ? "application/x-www-form-urlencoded" : "";
        }
        String canonicalizedAzureHeaders = HttpMsSharedKeyHelper.getCanonicalizedAzureHeaders(httpHeaders);
        String canonicalizedResource = HttpMsSharedKeyHelper.getCanonicalizedResourceName(request.getResourceRef());
        StringBuilder rest = new StringBuilder();
        rest.append(methodName).append('\n').append(contentMd5).append('\n').append(contentType).append('\n').append(date).append('\n').append(canonicalizedAzureHeaders).append('/').append(challenge.getIdentifier()).append(canonicalizedResource);
        sb.append(challenge.getIdentifier()).append(':').append(Base64.encode(DigestUtils.toHMac256(rest.toString(), Base64.decode(challenge.getSecret())), true));
    }
}

