/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.xml;

import java.io.IOException;
import java.io.Writer;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.Schema;
import org.restlet.data.MediaType;
import org.restlet.ext.xml.XmlRepresentation;
import org.restlet.ext.xml.XmlWriter;
import org.restlet.representation.Representation;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class SaxRepresentation
extends XmlRepresentation {
    public static final boolean XML_SECURE_PROCESSING = System.getProperty("org.restlet.ext.xml.secureProcessing") == null ? true : Boolean.getBoolean("org.restlet.ext.xml.secureProcessing");
    private boolean secureProcessing = XML_SECURE_PROCESSING;
    private volatile SAXSource source;
    private volatile Representation xmlRepresentation;

    public SaxRepresentation() {
        this(MediaType.TEXT_XML);
    }

    public SaxRepresentation(MediaType mediaType) {
        super(mediaType);
    }

    public SaxRepresentation(MediaType mediaType, Document xmlDocument) {
        super(mediaType);
        this.source = new SAXSource(SAXSource.sourceToInputSource(new DOMSource(xmlDocument)));
    }

    public SaxRepresentation(MediaType mediaType, InputSource xmlSource) {
        super(mediaType);
        this.source = new SAXSource(xmlSource);
    }

    public SaxRepresentation(MediaType mediaType, SAXSource xmlSource) {
        super(mediaType);
        this.source = xmlSource;
    }

    public SaxRepresentation(Representation xmlRepresentation) {
        super(xmlRepresentation == null ? null : xmlRepresentation.getMediaType());
        this.xmlRepresentation = xmlRepresentation;
    }

    public InputSource getInputSource() throws IOException {
        return this.getSaxSource() == null ? null : this.getSaxSource().getInputSource();
    }

    public SAXSource getSaxSource() throws IOException {
        if (this.source == null && this.xmlRepresentation != null) {
            if (this.xmlRepresentation instanceof XmlRepresentation) {
                this.source = ((XmlRepresentation)this.xmlRepresentation).getSaxSource();
            } else {
                try {
                    SAXParserFactory spf = SAXParserFactory.newInstance();
                    spf.setValidating(this.isValidatingDtd());
                    Schema xsd = this.getSchema();
                    if (xsd != null) {
                        spf.setSchema(xsd);
                    }
                    spf.setNamespaceAware(this.isNamespaceAware());
                    spf.setXIncludeAware(this.isXIncludeAware());
                    spf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", this.isSecureProcessing());
                    spf.setFeature("http://xml.org/sax/features/external-general-entities", this.isExpandingEntityRefs());
                    spf.setFeature("http://xml.org/sax/features/external-parameter-entities", this.isExpandingEntityRefs());
                    XMLReader xmlReader = spf.newSAXParser().getXMLReader();
                    this.source = new SAXSource(xmlReader, new InputSource(this.xmlRepresentation.getReader()));
                }
                catch (Exception e) {
                    throw new IOException("Unable to create customized SAX source");
                }
            }
            if (this.xmlRepresentation.getLocationRef() != null) {
                this.source.setSystemId(this.xmlRepresentation.getLocationRef().getTargetRef().toString());
            }
        }
        return this.source;
    }

    public boolean isSecureProcessing() {
        return this.secureProcessing;
    }

    public void parse(ContentHandler contentHandler) throws IOException {
        if (contentHandler != null) {
            try {
                SAXResult result = new SAXResult(contentHandler);
                TransformerFactory.newInstance().newTransformer().transform(this.getSaxSource(), result);
            }
            catch (TransformerConfigurationException tce) {
                throw new IOException("Couldn't parse the source representation: " + tce.getMessage());
            }
            catch (TransformerException te) {
                te.printStackTrace();
                throw new IOException("Couldn't parse the source representation: " + te.getMessage());
            }
            catch (TransformerFactoryConfigurationError tfce) {
                throw new IOException("Couldn't parse the source representation: " + tfce.getMessage());
            }
        } else {
            throw new IOException("Couldn't parse the source representation: no content restlet defined.");
        }
    }

    public void release() {
        if (this.source != null) {
            this.source = null;
        }
        if (this.xmlRepresentation != null) {
            this.xmlRepresentation.release();
        }
        super.release();
    }

    public void setSaxSource(SAXSource source) {
        this.source = source;
    }

    public void setSecureProcessing(boolean secureProcessing) {
        this.secureProcessing = secureProcessing;
    }

    public void write(Writer writer) throws IOException {
        XmlWriter xmlWriter = new XmlWriter(writer);
        this.write(xmlWriter);
    }

    public void write(XmlWriter writer) throws IOException {
        this.parse(writer);
    }
}

