/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.ssl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.restlet.Request;
import org.restlet.Server;
import org.restlet.data.Protocol;
import org.restlet.engine.connector.Connection;
import org.restlet.engine.connector.ConnectionController;
import org.restlet.engine.connector.ConnectionHelper;
import org.restlet.engine.connector.HttpServerHelper;
import org.restlet.engine.connector.InboundWay;
import org.restlet.engine.connector.OutboundWay;
import org.restlet.ext.ssl.SslContextFactory;
import org.restlet.ext.ssl.internal.HttpsInboundRequest;
import org.restlet.ext.ssl.internal.HttpsServerInboundWay;
import org.restlet.ext.ssl.internal.HttpsServerOutboundWay;
import org.restlet.ext.ssl.internal.SslConnection;
import org.restlet.ext.ssl.internal.SslUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpsServerHelper
extends HttpServerHelper {
    private volatile SSLContext sslContext;

    public HttpsServerHelper(Server server) {
        super(server, Protocol.HTTPS);
    }

    protected Connection<Server> createConnection(SocketChannel socketChannel, ConnectionController controller, InetSocketAddress socketAddress) throws IOException {
        SSLEngine engine = socketAddress != null ? this.getSslContext().createSSLEngine(socketAddress.getHostName(), socketAddress.getPort()) : this.getSslContext().createSSLEngine();
        return new SslConnection<Server>((ConnectionHelper<Server>)this, socketChannel, controller, socketAddress, engine);
    }

    public InboundWay createInboundWay(Connection<Server> connection, int bufferSize) {
        return new HttpsServerInboundWay(connection, bufferSize);
    }

    public OutboundWay createOutboundWay(Connection<Server> connection, int bufferSize) {
        return new HttpsServerOutboundWay(connection, bufferSize);
    }

    protected Request createRequest(Connection<Server> connection, String methodName, String resourceUri, String protocol) {
        return new HttpsInboundRequest(this.getContext(), connection, methodName, resourceUri, protocol);
    }

    protected SSLContext getSslContext() {
        return this.sslContext;
    }

    protected void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public synchronized void start() throws Exception {
        SslContextFactory factory = SslUtils.getSslContextFactory(this);
        this.setSslContext(factory.createSslContext());
        super.start();
    }
}

