/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.slf4j;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.slf4j.Logger;

public class Slf4jLogger
extends java.util.logging.Logger {
    private Logger slf4jLogger;

    public Slf4jLogger(Logger slf4jLogger) {
        super(slf4jLogger.getName(), null);
        this.slf4jLogger = slf4jLogger;
    }

    protected Slf4jLogger(String name, String resourceBundleName) {
        super(name, resourceBundleName);
    }

    @Override
    public void config(String msg) {
        this.getSlf4jLogger().debug(msg);
    }

    @Override
    public void fine(String msg) {
        this.getSlf4jLogger().debug(msg);
    }

    @Override
    public void finer(String msg) {
        this.getSlf4jLogger().trace(msg);
    }

    @Override
    public void finest(String msg) {
        this.getSlf4jLogger().trace(msg);
    }

    public Logger getSlf4jLogger() {
        return this.slf4jLogger;
    }

    @Override
    public void info(String msg) {
        this.getSlf4jLogger().info(msg);
    }

    @Override
    public boolean isLoggable(Level level) {
        if (Level.ALL == level) {
            return true;
        }
        if (Level.CONFIG == level) {
            return this.getSlf4jLogger().isDebugEnabled();
        }
        if (Level.FINE == level) {
            return this.getSlf4jLogger().isDebugEnabled();
        }
        if (Level.FINER == level) {
            return this.getSlf4jLogger().isTraceEnabled();
        }
        if (Level.FINEST == level) {
            return this.getSlf4jLogger().isTraceEnabled();
        }
        if (Level.INFO == level) {
            return this.getSlf4jLogger().isInfoEnabled();
        }
        if (Level.OFF == level) {
            return false;
        }
        if (Level.SEVERE == level) {
            return this.getSlf4jLogger().isErrorEnabled();
        }
        if (Level.WARNING == level) {
            return this.getSlf4jLogger().isWarnEnabled();
        }
        return false;
    }

    @Override
    public void log(Level level, String msg) {
        if (Level.CONFIG == level) {
            this.getSlf4jLogger().debug(msg);
        } else if (Level.FINE == level) {
            this.getSlf4jLogger().debug(msg);
        } else if (Level.FINER == level) {
            this.getSlf4jLogger().trace(msg);
        } else if (Level.FINEST == level) {
            this.getSlf4jLogger().trace(msg);
        } else if (Level.INFO == level) {
            this.getSlf4jLogger().info(msg);
        } else if (Level.SEVERE == level) {
            this.getSlf4jLogger().error(msg);
        } else if (Level.WARNING == level) {
            this.getSlf4jLogger().warn(msg);
        }
    }

    @Override
    public void log(Level level, String msg, Object param) {
        if (Level.CONFIG == level) {
            this.getSlf4jLogger().debug(msg, param);
        } else if (Level.FINE == level) {
            this.getSlf4jLogger().debug(msg, param);
        } else if (Level.FINER == level) {
            this.getSlf4jLogger().trace(msg, param);
        } else if (Level.FINEST == level) {
            this.getSlf4jLogger().trace(msg, param);
        } else if (Level.INFO == level) {
            this.getSlf4jLogger().info(msg, param);
        } else if (Level.SEVERE == level) {
            this.getSlf4jLogger().error(msg, param);
        } else if (Level.WARNING == level) {
            this.getSlf4jLogger().warn(msg, param);
        }
    }

    @Override
    public void log(Level level, String msg, Object[] params) {
        if (Level.CONFIG == level) {
            this.getSlf4jLogger().debug(msg, params);
        } else if (Level.FINE == level) {
            this.getSlf4jLogger().debug(msg, params);
        } else if (Level.FINER == level) {
            this.getSlf4jLogger().trace(msg, params);
        } else if (Level.FINEST == level) {
            this.getSlf4jLogger().trace(msg, params);
        } else if (Level.INFO == level) {
            this.getSlf4jLogger().info(msg, params);
        } else if (Level.SEVERE == level) {
            this.getSlf4jLogger().error(msg, params);
        } else if (Level.WARNING == level) {
            this.getSlf4jLogger().warn(msg, params);
        }
    }

    @Override
    public void log(Level level, String msg, Throwable thrown) {
        if (Level.CONFIG == level) {
            this.getSlf4jLogger().debug(msg, thrown);
        } else if (Level.FINE == level) {
            this.getSlf4jLogger().debug(msg, thrown);
        } else if (Level.FINER == level) {
            this.getSlf4jLogger().trace(msg, thrown);
        } else if (Level.FINEST == level) {
            this.getSlf4jLogger().trace(msg, thrown);
        } else if (Level.INFO == level) {
            this.getSlf4jLogger().info(msg, thrown);
        } else if (Level.SEVERE == level) {
            this.getSlf4jLogger().error(msg, thrown);
        } else if (Level.WARNING == level) {
            this.getSlf4jLogger().warn(msg, thrown);
        }
    }

    @Override
    public void log(LogRecord record) {
        Level level = record.getLevel();
        String msg = record.getMessage();
        Object[] params = record.getParameters();
        Throwable thrown = record.getThrown();
        if (thrown != null) {
            this.log(level, msg, thrown);
        } else if (params != null) {
            this.log(level, msg, params);
        } else {
            this.log(level, msg);
        }
    }

    public void setSlf4jLogger(Logger slf4jLogger) {
        this.slf4jLogger = slf4jLogger;
    }

    @Override
    public void severe(String msg) {
        this.getSlf4jLogger().error(msg);
    }

    @Override
    public void warning(String msg) {
        this.getSlf4jLogger().warn(msg);
    }
}

