/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.servlet.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.restlet.Response;
import org.restlet.Server;
import org.restlet.data.Protocol;
import org.restlet.data.Status;
import org.restlet.engine.adapter.ServerCall;
import org.restlet.engine.header.Header;
import org.restlet.engine.io.UnclosableInputStream;
import org.restlet.engine.io.UnclosableOutputStream;
import org.restlet.util.Series;

public class ServletCall
extends ServerCall {
    private volatile HttpServletRequest request;
    private volatile Series<Header> requestHeaders;
    private volatile HttpServletResponse response;

    public ServletCall(Server server, HttpServletRequest request, HttpServletResponse response) {
        super(server);
        this.request = request;
        this.response = response;
    }

    public ServletCall(String serverAddress, int serverPort, HttpServletRequest request, HttpServletResponse response) {
        super(serverAddress, serverPort);
        this.request = request;
        this.response = response;
    }

    public boolean abort() {
        return false;
    }

    public List<Certificate> getCertificates() {
        Certificate[] certificateArray = (Certificate[])this.getRequest().getAttribute("javax.servlet.request.X509Certificate");
        if (certificateArray != null) {
            return Arrays.asList(certificateArray);
        }
        return null;
    }

    public String getCipherSuite() {
        return (String)this.getRequest().getAttribute("javax.servlet.request.cipher_suite");
    }

    public String getClientAddress() {
        return this.getRequest().getRemoteAddr();
    }

    public int getClientPort() {
        return this.getRequest().getRemotePort();
    }

    public String getHostDomain() {
        return this.getRequest().getServerName();
    }

    public String getMethod() {
        return this.getRequest().getMethod();
    }

    public Protocol getProtocol() {
        return Protocol.valueOf((String)this.getRequest().getScheme());
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public InputStream getRequestEntityStream(long size) {
        try {
            return new UnclosableInputStream((InputStream)this.getRequest().getInputStream());
        }
        catch (IOException e) {
            return null;
        }
    }

    public Series<Header> getRequestHeaders() {
        if (this.requestHeaders == null) {
            this.requestHeaders = new Series(Header.class);
            Enumeration names = this.getRequest().getHeaderNames();
            while (names.hasMoreElements()) {
                String headerName = (String)names.nextElement();
                Enumeration values = this.getRequest().getHeaders(headerName);
                while (values.hasMoreElements()) {
                    String headerValue = (String)values.nextElement();
                    this.requestHeaders.add(headerName, headerValue);
                }
            }
        }
        return this.requestHeaders;
    }

    public InputStream getRequestHeadStream() {
        return null;
    }

    public String getRequestUri() {
        String queryString = this.getRequest().getQueryString();
        if (queryString == null || queryString.equals("")) {
            return this.getRequest().getRequestURI();
        }
        return this.getRequest().getRequestURI() + '?' + queryString;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public OutputStream getResponseEntityStream() {
        try {
            return new UnclosableOutputStream((OutputStream)this.getResponse().getOutputStream());
        }
        catch (IOException e) {
            return null;
        }
    }

    public String getServerAddress() {
        return this.getRequest().getLocalAddr();
    }

    public int getServerPort() {
        return this.getRequest().getServerPort();
    }

    public Integer getSslKeySize() {
        Integer keySize = (Integer)this.getRequest().getAttribute("javax.servlet.request.key_size");
        if (keySize == null) {
            keySize = super.getSslKeySize();
        }
        return keySize;
    }

    public String getSslSessionId() {
        Object sessionId = this.getRequest().getAttribute("javax.servlet.request.ssl_session_id");
        if (sessionId != null && sessionId instanceof String) {
            return (String)sessionId;
        }
        sessionId = this.getRequest().getAttribute("javax.servlet.request.ssl_session");
        if (sessionId instanceof String) {
            return (String)sessionId;
        }
        return null;
    }

    public Principal getUserPrincipal() {
        return this.getRequest().getUserPrincipal();
    }

    public String getVersion() {
        String result = null;
        int index = this.getRequest().getProtocol().indexOf(47);
        if (index != -1) {
            result = this.getRequest().getProtocol().substring(index + 1);
        }
        return result;
    }

    public boolean isConfidential() {
        return this.getRequest().isSecure();
    }

    public void sendResponse(Response response) throws IOException {
        if (Status.isError((int)this.getStatusCode()) && response.getEntity() == null) {
            try {
                for (Header header : this.getResponseHeaders()) {
                    if (header.getName().equals("Content-Length")) continue;
                    this.getResponse().addHeader(header.getName(), header.getValue());
                }
                this.getResponse().sendError(this.getStatusCode(), this.getReasonPhrase());
            }
            catch (IOException ioe) {
                this.getLogger().log(Level.WARNING, "Unable to set the response error status", ioe);
            }
        } else {
            this.getResponse().setStatus(this.getStatusCode());
            Header contentLengthHeader = null;
            for (Header header : this.getResponseHeaders()) {
                if (header.getName().equals("Content-Length")) {
                    contentLengthHeader = header;
                    continue;
                }
                this.getResponse().addHeader(header.getName(), header.getValue());
            }
            if (contentLengthHeader != null) {
                this.getResponse().addHeader(contentLengthHeader.getName(), contentLengthHeader.getValue());
            }
            super.sendResponse(response);
        }
    }
}

