/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.json;

import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.engine.io.IoUtils;
import org.restlet.representation.Representation;
import org.restlet.representation.WriterRepresentation;

public class JsonpRepresentation
extends WriterRepresentation {
    private final String callback;
    private final Status status;
    private final Representation wrappedRepresentation;

    public JsonpRepresentation(String callback, Status status, Representation wrappedRepresentation) {
        super(MediaType.APPLICATION_JAVASCRIPT);
        this.callback = callback;
        this.status = status;
        this.wrappedRepresentation = wrappedRepresentation;
    }

    public String getCallback() {
        return this.callback;
    }

    public long getSize() {
        long result = this.wrappedRepresentation.getSize();
        if (result > 0L && MediaType.APPLICATION_JSON.equals((Object)this.wrappedRepresentation.getMediaType())) {
            try {
                StringWriter sw = new StringWriter();
                this.write(sw);
                sw.flush();
                return sw.toString().length();
            }
            catch (IOException e) {
                return -1L;
            }
        }
        return -1L;
    }

    public Status getStatus() {
        return this.status;
    }

    public void write(Writer writer) throws IOException {
        writer.write(this.getCallback());
        writer.write("({\"status\":");
        writer.write(Integer.toString(this.getStatus().getCode()));
        writer.write(",\"body\":");
        if (MediaType.APPLICATION_JSON.equals((Object)this.wrappedRepresentation.getMediaType())) {
            IoUtils.copy((Reader)this.wrappedRepresentation.getReader(), (Writer)writer);
        } else {
            writer.write("\"");
            String text = this.wrappedRepresentation.getText();
            if (text.indexOf(34) >= 0) {
                text = text.replace("\"", "\\\"");
            }
            writer.write(text);
            writer.write("\"");
        }
        writer.write("});");
    }
}

