/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.json;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONStringer;
import org.json.JSONTokener;
import org.restlet.data.CharacterSet;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.representation.WriterRepresentation;

public class JsonRepresentation
extends WriterRepresentation {
    private boolean indenting;
    private int indentingSize;
    private Object jsonValue;
    private Representation jsonRepresentation;

    public JsonRepresentation(JSONArray jsonArray) {
        super(MediaType.APPLICATION_JSON);
        this.init(jsonArray);
    }

    public JsonRepresentation(JSONObject jsonObject) {
        super(MediaType.APPLICATION_JSON);
        this.init(jsonObject);
    }

    public JsonRepresentation(JSONStringer jsonStringer) {
        super(MediaType.APPLICATION_JSON);
        this.init(jsonStringer);
    }

    public JsonRepresentation(JSONTokener jsonTokener) {
        super(MediaType.APPLICATION_JSON);
        this.init(jsonTokener);
    }

    public JsonRepresentation(Map<String, Object> map) {
        this(new JSONObject(map));
    }

    public JsonRepresentation(Object bean) {
        this(new JSONObject(bean));
    }

    public JsonRepresentation(Representation jsonRepresentation) throws IOException {
        super(jsonRepresentation == null ? null : jsonRepresentation.getMediaType());
        this.jsonRepresentation = jsonRepresentation;
    }

    public JsonRepresentation(String jsonString) {
        super(MediaType.APPLICATION_JSON);
        this.setCharacterSet(CharacterSet.UTF_8);
        this.jsonRepresentation = new StringRepresentation((CharSequence)jsonString);
    }

    public int getIndentingSize() {
        return this.indentingSize;
    }

    public JSONArray getJsonArray() throws JSONException {
        if (this.jsonValue != null) {
            return (JSONArray)this.jsonValue;
        }
        return new JSONArray(this.getJsonText());
    }

    public JSONObject getJsonObject() throws JSONException {
        if (this.jsonValue != null) {
            return (JSONObject)this.jsonValue;
        }
        return new JSONObject(this.getJsonText());
    }

    private String getJsonText() throws JSONException {
        String result = null;
        if (this.jsonValue != null) {
            if (this.jsonValue instanceof JSONArray) {
                JSONArray jsonArray = (JSONArray)this.jsonValue;
                result = this.isIndenting() ? jsonArray.toString(this.getIndentingSize()) : jsonArray.toString();
            } else if (this.jsonValue instanceof JSONObject) {
                JSONObject jsonObject = (JSONObject)this.jsonValue;
                result = this.isIndenting() ? jsonObject.toString(this.getIndentingSize()) : jsonObject.toString();
            } else if (this.jsonValue instanceof JSONStringer) {
                JSONStringer jsonStringer = (JSONStringer)this.jsonValue;
                result = jsonStringer.toString();
            } else if (this.jsonValue instanceof JSONTokener) {
                JSONTokener jsonTokener = (JSONTokener)this.jsonValue;
                result = jsonTokener.toString();
            }
        } else if (this.jsonRepresentation != null) {
            try {
                result = this.jsonRepresentation.getText();
            }
            catch (IOException e) {
                throw new JSONException((Throwable)e);
            }
        }
        return result;
    }

    public JSONTokener getJsonTokener() throws JSONException {
        if (this.jsonValue != null) {
            return (JSONTokener)this.jsonValue;
        }
        return new JSONTokener(this.getJsonText());
    }

    public long getSize() {
        if (this.jsonRepresentation != null) {
            return this.jsonRepresentation.getSize();
        }
        return super.getSize();
    }

    private void init(Object jsonObject) {
        this.setCharacterSet(CharacterSet.UTF_8);
        this.jsonValue = jsonObject;
        this.indenting = false;
        this.indentingSize = 3;
    }

    public boolean isIndenting() {
        return this.indenting;
    }

    public void setIndenting(boolean indenting) {
        this.indenting = indenting;
    }

    public void setIndentingSize(int indentFactor) {
        this.indentingSize = indentFactor;
    }

    public void write(Writer writer) throws IOException {
        try {
            writer.write(this.getJsonText());
        }
        catch (JSONException e) {
            IOException ioe = new IOException(e.getLocalizedMessage());
            ioe.initCause(e.getCause());
            throw ioe;
        }
    }
}

