/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.crypto.internal;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.restlet.Request;
import org.restlet.data.Method;
import org.restlet.data.Parameter;
import org.restlet.data.Reference;
import org.restlet.engine.header.Header;
import org.restlet.engine.io.BioUtils;
import org.restlet.engine.util.Base64;
import org.restlet.engine.util.DateUtils;
import org.restlet.engine.util.SystemUtils;
import org.restlet.ext.crypto.DigestUtils;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AwsUtils {
    public static String getCanonicalizedAmzHeaders(Series<Header> requestHeaders) {
        StringBuilder sb = new StringBuilder();
        Pattern spacePattern = Pattern.compile("\\s+");
        TreeMap<String, String> amzHeaders = new TreeMap<String, String>();
        if (requestHeaders != null) {
            for (Header header : requestHeaders) {
                String name = header.getName().toLowerCase();
                if (!name.startsWith("x-amz-")) continue;
                String value = "";
                value = amzHeaders.containsKey(name) ? (String)amzHeaders.get(name) + "," + header.getValue() : header.getValue();
                Matcher m = spacePattern.matcher(value);
                value = m.replaceAll(" ");
                amzHeaders.put(name, value);
            }
        }
        for (Map.Entry entry : amzHeaders.entrySet()) {
            sb.append((String)entry.getKey()).append(':').append((String)entry.getValue()).append("\n");
        }
        return sb.toString();
    }

    public static String getCanonicalizedResourceName(Reference reference) {
        int queryIdx;
        String hostName = reference.getHostDomain();
        String path = reference.getPath();
        Pattern hostNamePattern = Pattern.compile("s3[a-z0-1\\-]*.amazonaws.com");
        StringBuilder sb = new StringBuilder();
        if (hostName != null) {
            if (hostName.contains(":")) {
                hostName = hostName.substring(0, hostName.indexOf(":"));
            }
            Matcher hostNameMatcher = hostNamePattern.matcher(hostName);
            if (hostName.endsWith(".s3.amazonaws.com")) {
                String bucketName = hostName.substring(0, hostName.length() - 17);
                sb.append("/" + bucketName);
            } else if (!hostNameMatcher.matches()) {
                sb.append("/" + hostName);
            }
        }
        if ((queryIdx = path.indexOf("?")) >= 0) {
            sb.append(path.substring(0, queryIdx));
        } else {
            sb.append(path.substring(0, path.length()));
        }
        if (queryIdx >= 0) {
            String query = path.substring(queryIdx - 1, path.length());
            if (query.contains("?acl")) {
                sb.append("?acl");
            } else if (query.contains("?location")) {
                sb.append("?location");
            } else if (query.contains("?logging")) {
                sb.append("?logging");
            } else if (query.contains("?torrent")) {
                sb.append("?torrent");
            }
        }
        return sb.toString();
    }

    public static String getHmacSha1Signature(String stringToSign, char[] secret) {
        return Base64.encode((byte[])DigestUtils.toHMacSha1(stringToSign, BioUtils.toByteArray((char[])secret)), (boolean)false);
    }

    public static String getHmacSha256Signature(String stringToSign, char[] secret) {
        return Base64.encode((byte[])DigestUtils.toHMacSha256(stringToSign, BioUtils.toByteArray((char[])secret)), (boolean)false);
    }

    public static String getQuerySignature(Method method, Reference resourceRef, List<Parameter> params, char[] secret) {
        return AwsUtils.getHmacSha256Signature(AwsUtils.getQueryStringToSign(method, resourceRef, params), secret);
    }

    public static String getQueryStringToSign(Method method, Reference resourceRef, List<Parameter> params) {
        StringBuilder toSign = new StringBuilder();
        toSign.append(method != null ? method.getName() : "").append("\n");
        String domain = resourceRef.getHostDomain();
        toSign.append(domain != null ? domain : "").append("\n");
        String path = resourceRef.getPath();
        toSign.append(path != null ? path : "").append("\n");
        Collections.sort(params);
        for (int i = 0; i < params.size(); ++i) {
            Parameter param = params.get(i);
            if (i > 0) {
                toSign.append('&');
            }
            toSign.append(Reference.encode((String)param.getName()));
            if (param.getValue() == null) continue;
            toSign.append('=').append(Reference.encode((String)param.getValue(), (boolean)true));
        }
        return toSign.toString();
    }

    public static String getS3Signature(Request request, char[] secret) {
        Series headers = (Series)request.getAttributes().get("org.restlet.http.headers");
        return AwsUtils.getS3Signature(request, (Series<Header>)headers, secret);
    }

    public static String getS3Signature(Request request, Series<Header> headers, char[] secret) {
        return AwsUtils.getHmacSha1Signature(AwsUtils.getS3StringToSign(request, headers), secret);
    }

    public static String getS3StringToSign(Request request) {
        Series headers = (Series)request.getAttributes().get("org.restlet.http.headers");
        return AwsUtils.getS3StringToSign(request, (Series<Header>)headers);
    }

    public static String getS3StringToSign(Request request, Series<Header> headers) {
        String canonicalizedAmzHeaders = AwsUtils.getCanonicalizedAmzHeaders(headers);
        String canonicalizedResource = AwsUtils.getCanonicalizedResourceName(request.getResourceRef());
        String contentMD5 = headers == null ? null : headers.getFirstValue("Content-MD5", true);
        String contentType = headers == null ? null : headers.getFirstValue("Content-Type", true);
        String date = headers == null ? null : headers.getFirstValue("X-Amz-Date", true);
        String method = request.getMethod().getName();
        if (date == null || date.length() == 0) {
            String string = date = headers == null ? null : headers.getFirstValue("Date", true);
        }
        if (date == null || date.length() == 0) {
            date = DateUtils.format((Date)new Date(), (String)((String)DateUtils.FORMAT_RFC_1123.get(0)));
            if (headers != null) {
                headers.add("Date", date);
            }
        }
        if (contentType == null || contentType.length() == 0) {
            boolean applyPatch = false;
            String jvmVendor = System.getProperty("java.vm.vendor");
            if (jvmVendor != null && jvmVendor.toLowerCase().startsWith("sun")) {
                int majorVersionNumber = SystemUtils.getJavaMajorVersion();
                int minorVersionNumber = SystemUtils.getJavaMinorVersion();
                if (majorVersionNumber == 1) {
                    if (minorVersionNumber < 5) {
                        applyPatch = true;
                    } else if (minorVersionNumber == 5) {
                        boolean bl = applyPatch = SystemUtils.getJavaUpdateVersion() < 10;
                    }
                }
            }
            if (applyPatch && !request.getMethod().equals((Object)Method.PUT)) {
                contentType = "application/x-www-form-urlencoded";
            }
        }
        StringBuilder toSign = new StringBuilder();
        toSign.append(method != null ? method : "").append("\n");
        toSign.append(contentMD5 != null ? contentMD5 : "").append("\n");
        toSign.append(contentType != null ? contentType : "").append("\n");
        toSign.append(date != null ? date : "").append("\n");
        toSign.append(canonicalizedAmzHeaders != null ? canonicalizedAmzHeaders : "");
        toSign.append(canonicalizedResource != null ? canonicalizedResource : "");
        return toSign.toString();
    }
}

