/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.atom;

import org.restlet.data.Language;
import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.ext.atom.Content;
import org.restlet.ext.atom.Relation;
import org.restlet.ext.xml.XmlWriter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Link {
    private volatile Content content;
    private volatile Reference href;
    private volatile Language hrefLang;
    private volatile long length;
    private volatile Relation rel;
    private volatile String title;
    private volatile MediaType type;

    public Link() {
        this.content = null;
        this.href = null;
        this.rel = null;
        this.type = null;
        this.hrefLang = null;
        this.title = null;
        this.length = -1L;
    }

    public Link(Reference href, Relation rel, MediaType type) {
        this.href = href;
        this.rel = rel;
        this.type = type;
    }

    public Content getContent() {
        return this.content;
    }

    public Reference getHref() {
        return this.href;
    }

    public Language getHrefLang() {
        return this.hrefLang;
    }

    public long getLength() {
        return this.length;
    }

    public Relation getRel() {
        return this.rel;
    }

    public String getTitle() {
        return this.title;
    }

    public MediaType getType() {
        return this.type;
    }

    public void setContent(Content content) {
        this.content = content;
    }

    public void setHref(Reference href) {
        this.href = href;
    }

    public void setHrefLang(Language hrefLang) {
        this.hrefLang = hrefLang;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public void setRel(Relation rel) {
        this.rel = rel;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setType(MediaType type) {
        this.type = type;
    }

    public void writeElement(XmlWriter writer) throws SAXException {
        AttributesImpl attributes = new AttributesImpl();
        if (this.getHref() != null && this.getHref().toString() != null) {
            attributes.addAttribute("", "href", null, "atomURI", this.getHref().toString());
        }
        if (this.getHrefLang() != null && this.getHrefLang().toString() != null) {
            attributes.addAttribute("", "hreflang", null, "atomLanguageTag", this.getHrefLang().toString());
        }
        if (this.getLength() > 0L) {
            attributes.addAttribute("", "length", null, "text", Long.toString(this.getLength()));
        }
        attributes.addAttribute("", "rel", null, "text", Relation.toString(this.getRel()));
        if (this.getTitle() != null) {
            attributes.addAttribute("", "title", null, "text", this.getTitle());
        }
        if (this.getType() != null) {
            attributes.addAttribute("", "type", null, "atomMediaType", this.getType().toString());
        }
        if (this.getContent() != null) {
            writer.startElement("http://www.w3.org/2005/Atom", "link", null, (Attributes)attributes);
            this.getContent().writeElement(writer);
            writer.endElement("http://www.w3.org/2005/Atom", "link");
        } else {
            writer.emptyElement("http://www.w3.org/2005/Atom", "link", null, (Attributes)attributes);
        }
    }
}

