/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.atom;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.restlet.Client;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Reference;
import org.restlet.engine.util.DateUtils;
import org.restlet.ext.atom.Category;
import org.restlet.ext.atom.Entry;
import org.restlet.ext.atom.FeedReader;
import org.restlet.ext.atom.Generator;
import org.restlet.ext.atom.Link;
import org.restlet.ext.atom.Person;
import org.restlet.ext.atom.Text;
import org.restlet.ext.atom.internal.FeedContentReader;
import org.restlet.ext.xml.SaxRepresentation;
import org.restlet.ext.xml.XmlWriter;
import org.restlet.representation.Representation;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Feed
extends SaxRepresentation {
    public static final String ATOM_NAMESPACE = "http://www.w3.org/2005/Atom";
    public static final String XHTML_NAMESPACE = "http://www.w3.org/1999/xhtml";
    private volatile List<Person> authors;
    private volatile Reference baseReference;
    private volatile List<Category> categories;
    private volatile List<Person> contributors;
    private List<Entry> entries;
    private volatile Generator generator;
    private volatile Reference icon;
    private volatile String id;
    private volatile List<Link> links;
    private volatile Reference logo;
    private volatile Text rights;
    private volatile Text subtitle;
    private volatile Text title;
    private volatile Date updated;

    public Feed() {
        super(MediaType.APPLICATION_ATOM);
        this.setNamespaceAware(true);
        this.authors = null;
        this.categories = null;
        this.contributors = null;
        this.generator = null;
        this.icon = null;
        this.id = null;
        this.links = null;
        this.logo = null;
        this.rights = null;
        this.subtitle = null;
        this.title = null;
        this.updated = null;
        this.entries = null;
    }

    public Feed(Client clientDispatcher, String feedUri) throws IOException {
        this(clientDispatcher.handle(new Request(Method.GET, feedUri)).getEntity());
    }

    public Feed(Context context, String feedUri) throws IOException {
        this(context.getClientDispatcher().handle(new Request(Method.GET, feedUri)).getEntity());
    }

    public Feed(Representation xmlFeed) throws IOException {
        super(xmlFeed);
        this.setNamespaceAware(true);
        this.parse(new FeedContentReader(this));
    }

    public Feed(Representation xmlFeed, FeedReader feedReader) throws IOException {
        super(xmlFeed);
        this.setNamespaceAware(true);
        this.parse(new FeedContentReader(this, feedReader));
    }

    public Feed(String feedUri) throws IOException {
        this(new Client(new Reference(feedUri).getSchemeProtocol()), feedUri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Person> getAuthors() {
        List<Person> a = this.authors;
        if (a == null) {
            Feed feed = this;
            synchronized (feed) {
                a = this.authors;
                if (a == null) {
                    this.authors = a = new ArrayList<Person>();
                }
            }
        }
        return a;
    }

    public Reference getBaseReference() {
        return this.baseReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Category> getCategories() {
        List<Category> c = this.categories;
        if (c == null) {
            Feed feed = this;
            synchronized (feed) {
                c = this.categories;
                if (c == null) {
                    this.categories = c = new ArrayList<Category>();
                }
            }
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Person> getContributors() {
        List<Person> c = this.contributors;
        if (c == null) {
            Feed feed = this;
            synchronized (feed) {
                c = this.contributors;
                if (c == null) {
                    this.contributors = c = new ArrayList<Person>();
                }
            }
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Entry> getEntries() {
        List<Entry> e = this.entries;
        if (e == null) {
            Feed feed = this;
            synchronized (feed) {
                e = this.entries;
                if (e == null) {
                    this.entries = e = new ArrayList<Entry>();
                }
            }
        }
        return e;
    }

    public Generator getGenerator() {
        return this.generator;
    }

    public Reference getIcon() {
        return this.icon;
    }

    public String getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Link> getLinks() {
        List<Link> l = this.links;
        if (l == null) {
            Feed feed = this;
            synchronized (feed) {
                l = this.links;
                if (l == null) {
                    this.links = l = new ArrayList<Link>();
                }
            }
        }
        return l;
    }

    public Reference getLogo() {
        return this.logo;
    }

    public Text getRights() {
        return this.rights;
    }

    public Text getSubtitle() {
        return this.subtitle;
    }

    public Text getTitle() {
        return this.title;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public void setBaseReference(Reference baseReference) {
        this.baseReference = baseReference;
    }

    public void setBaseReference(String baseUri) {
        this.setBaseReference(new Reference(baseUri));
    }

    public void setGenerator(Generator generator) {
        this.generator = generator;
    }

    public void setIcon(Reference icon) {
        this.icon = icon;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setLogo(Reference logo) {
        this.logo = logo;
    }

    public void setRights(Text rights) {
        this.rights = rights;
    }

    public void setSubtitle(Text subtitle) {
        this.subtitle = subtitle;
    }

    public void setTitle(Text title) {
        this.title = title;
    }

    public void setUpdated(Date updated) {
        this.updated = DateUtils.unmodifiable((Date)updated);
    }

    public void write(XmlWriter writer) throws IOException {
        try {
            writer.setPrefix(ATOM_NAMESPACE, "");
            writer.setDataFormat(true);
            writer.setIndentStep(3);
            writer.startDocument();
            this.writeElement(writer);
            writer.endDocument();
        }
        catch (SAXException e) {
            IOException ioe = new IOException("Unable to write the Atom feed document.");
            ioe.initCause(e);
            throw ioe;
        }
    }

    public void writeElement(XmlWriter writer) throws SAXException {
        writer.startElement(ATOM_NAMESPACE, "feed");
        if (this.getAuthors() != null) {
            for (Person person : this.getAuthors()) {
                person.writeElement(writer, "author");
            }
        }
        if (this.getCategories() != null) {
            for (Category category : this.getCategories()) {
                category.writeElement(writer);
            }
        }
        if (this.getContributors() != null) {
            for (Person person : this.getContributors()) {
                person.writeElement(writer, "contributor");
            }
        }
        if (this.getGenerator() != null) {
            this.getGenerator().writeElement(writer);
        }
        if (this.getIcon() != null) {
            writer.dataElement(ATOM_NAMESPACE, "icon", this.getIcon().toString());
        }
        if (this.getId() != null) {
            writer.dataElement(ATOM_NAMESPACE, "id", null, (Attributes)new AttributesImpl(), this.getId());
        }
        if (this.getLinks() != null) {
            for (Link link : this.getLinks()) {
                link.writeElement(writer);
            }
        }
        if (this.getLogo() != null && this.getLogo().toString() != null) {
            writer.dataElement(ATOM_NAMESPACE, "logo", this.getLogo().toString());
        }
        if (this.getRights() != null) {
            this.getRights().writeElement(writer, "rights");
        }
        if (this.getSubtitle() != null) {
            this.getSubtitle().writeElement(writer, "subtitle");
        }
        if (this.getTitle() != null) {
            this.getTitle().writeElement(writer, "title");
        }
        if (this.getUpdated() != null) {
            Text.writeElement(writer, this.getUpdated(), ATOM_NAMESPACE, "updated");
        }
        if (this.getEntries() != null) {
            for (Entry entry : this.getEntries()) {
                entry.writeElement(writer);
            }
        }
        writer.endElement(ATOM_NAMESPACE, "feed");
    }
}

