/*
 * Decompiled with CFR 0.152.
 */
package org.restdoc.server.impl.util;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.JsonSchemaGenerator;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Map;
import org.restdoc.annotations.RestDocSchema;
import org.restdoc.api.Schema;
import org.restdoc.api.util.RestDocParser;
import org.restdoc.server.impl.IRestDocGeneratorExtension;
import org.restdoc.server.impl.RestDocException;

public final class SchemaResolver {
    private static final ObjectMapper mapper = RestDocParser.createMapper();

    private SchemaResolver() {
    }

    public static String getSchemaFromType(Type type, Map<String, Schema> schemaMap, IRestDocGeneratorExtension ext) {
        String schema = SchemaResolver.getSchemaFromTypeOrNull(type, schemaMap, ext);
        if (schema != null) {
            return schema;
        }
        String s = String.format("SchemaType %s is not annotated with RestDocSchema.", type);
        throw new RestDocException(s);
    }

    public static String getSchemaFromTypeOrNull(Type type, Map<String, Schema> schemaMap, IRestDocGeneratorExtension ext) {
        if (type.equals(Void.TYPE)) {
            return null;
        }
        if (type instanceof Class) {
            return SchemaResolver.getSchemaFromClassOrNull((Class)type, schemaMap, ext);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            Type rawType = pt.getRawType();
            Type[] arguments = pt.getActualTypeArguments();
            if (rawType instanceof Class) {
                Class rawClass = (Class)rawType;
                if (Collection.class.isAssignableFrom(rawClass) && arguments.length == 1) {
                    String nestedSchema = SchemaResolver.getSchemaFromTypeOrNull(arguments[0], schemaMap, ext);
                    return nestedSchema + "[]";
                }
                if (Map.class.isAssignableFrom(rawClass)) {
                    return "object";
                }
            }
        }
        return type.toString();
    }

    private static String getSchemaFromClassOrNull(Class<?> schemaClass, Map<String, Schema> schemaMap, IRestDocGeneratorExtension ext) {
        if (schemaClass.isArray()) {
            return SchemaResolver.getSchemaFromClassOrNull(schemaClass.getComponentType(), schemaMap, ext) + "[]";
        }
        if (schemaClass.isAssignableFrom(String.class)) {
            return "string";
        }
        if (schemaClass.isAssignableFrom(Integer.class) || schemaClass.equals(Integer.TYPE)) {
            return "integer";
        }
        if (schemaClass.isAssignableFrom(Long.class) || schemaClass.equals(Long.TYPE)) {
            return "long";
        }
        if (schemaClass.isAssignableFrom(Boolean.class) || schemaClass.equals(Boolean.TYPE)) {
            return "boolean";
        }
        if (schemaClass.isAssignableFrom(Double.class) || schemaClass.equals(Double.TYPE)) {
            return "double";
        }
        if (schemaClass.isAssignableFrom(BigDecimal.class)) {
            return "double";
        }
        if (schemaClass.isAnnotationPresent(RestDocSchema.class)) {
            RestDocSchema docSchema = schemaClass.getAnnotation(RestDocSchema.class);
            String schemaURI = docSchema.value();
            if (schemaMap != null && !schemaMap.containsKey(schemaURI)) {
                try {
                    JsonSchemaGenerator gen = new JsonSchemaGenerator(mapper);
                    JsonSchema schema = gen.generateSchema(schemaClass);
                    Schema s = new Schema();
                    s.setSchema(schema);
                    schemaMap.put(schemaURI, s);
                    if (ext != null) {
                        ext.newSchema(schemaURI, s, schemaClass);
                    }
                }
                catch (JsonMappingException e) {
                    throw new RestDocException("Error creating schema for URI: " + schemaURI, e);
                }
            }
            return schemaURI;
        }
        return schemaClass.getCanonicalName();
    }
}

