/*
 * Decompiled with CFR 0.152.
 */
package org.restdoc.server.impl;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.ws.rs.BeanParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.restdoc.annotations.RestDocAccept;
import org.restdoc.annotations.RestDocHeader;
import org.restdoc.annotations.RestDocIgnore;
import org.restdoc.annotations.RestDocParam;
import org.restdoc.annotations.RestDocResponse;
import org.restdoc.annotations.RestDocReturnCode;
import org.restdoc.annotations.RestDocReturnCodes;
import org.restdoc.annotations.RestDocType;
import org.restdoc.annotations.RestDocValidation;
import org.restdoc.api.GlobalHeader;
import org.restdoc.api.HeaderDefinition;
import org.restdoc.api.MethodDefinition;
import org.restdoc.api.ParamDefinition;
import org.restdoc.api.ParamValidation;
import org.restdoc.api.Representation;
import org.restdoc.api.ResponseDefinition;
import org.restdoc.api.RestDoc;
import org.restdoc.api.RestResource;
import org.restdoc.api.Schema;
import org.restdoc.api.util.RestDocParser;
import org.restdoc.server.impl.AnnotationMap;
import org.restdoc.server.impl.IProvideRestDoc;
import org.restdoc.server.impl.IRestDocGeneratorExtension;
import org.restdoc.server.impl.RestDocException;
import org.restdoc.server.impl.util.MediaTypeResolver;
import org.restdoc.server.impl.util.SchemaResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestDocGenerator {
    private static final String VALIDATION_MATCH = "match";
    private static final String PATTERN_BOOL = "true|false";
    private static final String PATTERN_SIGNED_DECIMAL = "[-+]?[0-9]*\\.?[0-9]+";
    private static final String PATTERN_SIGNED_INT = "[-+]?[0-9]+";
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, RestResource> resources = Maps.newHashMap();
    private final Map<String, HeaderDefinition> requestHeaderMap = Maps.newConcurrentMap();
    private final Map<String, HeaderDefinition> responseHeaderMap = Maps.newConcurrentMap();
    private final Map<String, Schema> schemaMap = Maps.newConcurrentMap();
    private final Map<String, Object> globalAdditional = Maps.newConcurrentMap();
    private final RDGEWrapper ext = new RDGEWrapper();

    public void init(Class<?>[] classes, GlobalHeader globalHeader, String baseURI) {
        if (!this.initialized.compareAndSet(false, true)) {
            throw new RestDocException("Generator already initialized");
        }
        this.logger.info("Starting generation of RestDoc");
        this.logger.info("Searching for RestDoc API classes");
        if (globalHeader != null) {
            if (globalHeader.getRequestHeader() != null) {
                this.requestHeaderMap.putAll(globalHeader.getRequestHeader());
            }
            if (globalHeader.getResponseHeader() != null) {
                this.responseHeaderMap.putAll(globalHeader.getResponseHeader());
            }
            if (globalHeader.getAdditionalFields() != null && !globalHeader.getAdditionalFields().isEmpty()) {
                this.globalAdditional.putAll(globalHeader.getAdditionalFields());
            }
        }
        for (Class<?> apiClass : classes) {
            boolean scanNeeded = true;
            if (Arrays.asList(apiClass.getInterfaces()).contains(IProvideRestDoc.class)) {
                try {
                    RestResource[] restDocResources;
                    this.logger.info("Class {} provides predefined RestDoc", (Object)apiClass.getCanonicalName());
                    IProvideRestDoc apiObject = (IProvideRestDoc)apiClass.newInstance();
                    for (RestResource restResource : restDocResources = apiObject.getRestDocResources()) {
                        this.resources.put(restResource.getPath(), restResource);
                    }
                    this.schemaMap.putAll(apiObject.getRestDocSchemas());
                    scanNeeded = false;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (!scanNeeded) continue;
            this.addResourcesOfClass(apiClass, baseURI);
        }
    }

    private void addResourcesOfClass(Class<?> apiClass, String baseURI) {
        Method[] methods;
        String basepath;
        this.logger.info("Scanning class: {}", (Object)apiClass.getCanonicalName());
        String string = basepath = baseURI != null ? baseURI : "";
        if (apiClass.isAnnotationPresent(Path.class)) {
            Path path = apiClass.getAnnotation(Path.class);
            basepath = basepath + path.value();
        }
        for (Method method : methods = apiClass.getMethods()) {
            if (!method.isAnnotationPresent(Path.class) && RestDocGenerator.getHTTPVerb(method) == null) continue;
            this.logger.debug("Generating RestDoc of method: " + method.toString());
            this.addResourceMethod(basepath, method);
        }
    }

    private void addResourceMethod(String basepath, Method method) {
        MethodDefinition def;
        String methodDescription;
        String resourceDescription;
        if (method.isAnnotationPresent(RestDocIgnore.class)) {
            this.logger.info("Ignoring method: " + method);
            return;
        }
        String methodType = RestDocGenerator.getHTTPVerb(method);
        org.restdoc.annotations.RestDoc docAnnotation = method.getAnnotation(org.restdoc.annotations.RestDoc.class);
        Path pathAnnotation = method.getAnnotation(Path.class);
        String path = basepath;
        if (pathAnnotation != null) {
            path = path + pathAnnotation.value();
        }
        if (methodType == null && pathAnnotation != null) {
            this.addResourcesOfClass(method.getReturnType(), path);
            return;
        }
        Type[] parameterTypes = method.getGenericParameterTypes();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        ArrayList queryParams = Lists.newArrayList();
        HashMap methodRequestHeader = Maps.newHashMap();
        HashMap methodParams = Maps.newHashMap();
        for (int i = 0; i < parameterTypes.length; ++i) {
            this.parseMethodParameter(queryParams, methodRequestHeader, methodParams, parameterTypes[i], parameterAnnotations[i]);
        }
        for (String string : queryParams) {
            path = path + "{?" + string + "}";
        }
        String id = docAnnotation != null && docAnnotation.id() != null && !docAnnotation.id().isEmpty() ? docAnnotation.id() : this.getDefaultResourceId(method, path);
        if (docAnnotation == null) {
            if (method.getDeclaringClass().isAnnotationPresent(org.restdoc.annotations.RestDoc.class)) {
                org.restdoc.annotations.RestDoc doc = method.getDeclaringClass().getAnnotation(org.restdoc.annotations.RestDoc.class);
                resourceDescription = doc.resourceDescription();
            } else {
                resourceDescription = null;
            }
        } else {
            resourceDescription = docAnnotation.resourceDescription();
        }
        String string = methodDescription = docAnnotation != null ? docAnnotation.methodDescription() : method.getName();
        if (methodType == null) {
            throw new RestDocException("No suitable method found for method: " + method.toString());
        }
        RestResource restResource = this.resources.get(path);
        if (restResource == null) {
            restResource = new RestResource();
            restResource.setPath(path);
            this.resources.put(path, restResource);
        }
        if (restResource.getId() == null || restResource.getId().isEmpty()) {
            restResource.setId(id);
            restResource.setDescription(resourceDescription);
            restResource.getParams().putAll(methodParams);
            this.ext.newResource(restResource);
        }
        if (!restResource.getMethods().containsKey(methodType)) {
            def = new MethodDefinition();
            def.setDescription(methodDescription);
            def.setResponse(new ResponseDefinition());
        } else {
            def = (MethodDefinition)restResource.getMethods().get(methodType);
        }
        def.getHeaders().putAll(methodRequestHeader);
        def.getAccepts().addAll(this.getAccepts(method, parameterTypes, parameterAnnotations));
        def.getStatusCodes().putAll(this.getStatusCodes(method));
        this.addMethodResponse(def.getResponse(), method);
        restResource.getMethods().put(methodType, def);
        this.ext.newMethod(restResource, def, method);
    }

    private String getDefaultResourceId(Method method, String path) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] digest = md.digest(path.getBytes("UTF-8"));
            BigInteger bigInt = new BigInteger(1, digest);
            String hashtext = bigInt.toString(16);
            while (hashtext.length() < 32) {
                hashtext = "0" + hashtext;
            }
            return hashtext;
        }
        catch (NoSuchAlgorithmException e) {
            this.logger.warn("Failed to generate MD5 sum", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            this.logger.warn("Failed to generate MD5 sum", (Throwable)e);
        }
        return method.getName();
    }

    protected void parseMethodParameter(List<String> queryParams, Map<String, HeaderDefinition> methodRequestHeader, Map<String, ParamDefinition> methodParams, Type paramType, Annotation[] paramAnnotations) {
        HeaderDefinition headerDefinition = new HeaderDefinition();
        AnnotationMap map = new AnnotationMap(paramAnnotations);
        if (map.hasAnnotation((Class<? extends Annotation>)QueryParam.class)) {
            String name = map.getAnnotation(QueryParam.class).value();
            queryParams.add(name);
            ParamDefinition definition = new ParamDefinition();
            if (map.hasAnnotation((Class<? extends Annotation>)RestDocParam.class)) {
                this.parseRestDocParameter(definition, map.getAnnotation(RestDocParam.class), paramType);
            }
            this.ext.queryParam(name, definition, paramType, map);
            methodParams.put(name, definition);
        } else if (map.hasAnnotation((Class<? extends Annotation>)PathParam.class)) {
            String name = map.getAnnotation(PathParam.class).value();
            ParamDefinition definition = new ParamDefinition();
            if (map.hasAnnotation((Class<? extends Annotation>)RestDocParam.class)) {
                this.parseRestDocParameter(definition, map.getAnnotation(RestDocParam.class), paramType);
            }
            this.ext.pathParam(name, definition, paramType, map);
            methodParams.put(name, definition);
        } else if (map.hasAnnotation((Class<? extends Annotation>)HeaderParam.class)) {
            String name = map.getAnnotation(HeaderParam.class).value();
            HeaderDefinition definition = new HeaderDefinition();
            if (!this.requestHeaderMap.containsKey(name)) {
                if (map.hasAnnotation((Class<? extends Annotation>)RestDocHeader.class)) {
                    RestDocHeader docHeader = map.getAnnotation(RestDocHeader.class);
                    headerDefinition.setDescription(docHeader.description());
                    headerDefinition.setRequired(docHeader.required());
                }
                this.ext.headerParam(name, definition, paramType, map);
                methodRequestHeader.put(name, headerDefinition);
            }
        } else if (map.hasAnnotation((Class<? extends Annotation>)BeanParam.class) && paramType instanceof Class) {
            Field[] fields;
            Class beanParamClass = (Class)paramType;
            for (Field f : fields = beanParamClass.getDeclaredFields()) {
                this.parseMethodParameter(queryParams, methodRequestHeader, methodParams, f.getType(), f.getAnnotations());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addMethodResponse(ResponseDefinition def, Method method) {
        boolean typeFound = false;
        if (method.isAnnotationPresent(RestDocResponse.class)) {
            void var9_15;
            RestDocHeader[] restDocHeaderArray;
            RestDocType[] types;
            RestDocResponse docResponse = method.getAnnotation(RestDocResponse.class);
            RestDocType[] restDocTypeArray = types = docResponse.types();
            int len$ = restDocTypeArray.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                RestDocType restDocType = restDocTypeArray[i$];
                if (!restDocType.schemaClass().equals(Object.class)) {
                    String schema = SchemaResolver.getSchemaFromType(restDocType.schemaClass(), this.schemaMap, this.ext);
                    def.type(restDocType.type(), schema);
                    typeFound = true;
                    continue;
                }
                def.type(restDocType.type(), restDocType.schema());
                typeFound = true;
            }
            RestDocHeader[] arr$ = restDocHeaderArray = docResponse.headers();
            int len$2 = arr$.length;
            boolean bl = false;
            while (var9_15 < len$2) {
                RestDocHeader restDocHeader = arr$[var9_15];
                def.header(restDocHeader.name(), restDocHeader.description(), restDocHeader.required());
                ++var9_15;
            }
        }
        if (!typeFound && !method.getReturnType().equals(Void.TYPE)) {
            String schema = SchemaResolver.getSchemaFromTypeOrNull(method.getGenericReturnType(), this.schemaMap, this.ext);
            String[] mediaTypes = MediaTypeResolver.getProducesMediaType(method);
            if (mediaTypes != null) {
                for (String string : mediaTypes) {
                    def.type(string, schema);
                }
            }
        }
    }

    private Map<String, String> getStatusCodes(Method method) {
        HashMap codeMap = Maps.newHashMap();
        if (method.isAnnotationPresent(RestDocReturnCodes.class)) {
            RestDocReturnCode[] returnCodes;
            for (RestDocReturnCode rdrc : returnCodes = method.getAnnotation(RestDocReturnCodes.class).value()) {
                String description = rdrc.description();
                if (description.isEmpty()) {
                    description = Response.Status.fromStatusCode((int)Integer.valueOf(rdrc.code())).getReasonPhrase();
                }
                codeMap.put(rdrc.code(), description);
            }
        }
        if (method.getReturnType().equals(Void.TYPE)) {
            codeMap.put(String.valueOf(Response.Status.NO_CONTENT.getStatusCode()), Response.Status.NO_CONTENT.getReasonPhrase());
        }
        return codeMap;
    }

    private Collection<Representation> getAccepts(Method method, Type[] parameterTypes, Annotation[][] parameterAnnotations) {
        ArrayList list;
        block5: {
            block4: {
                RestDocType[] types;
                list = Lists.newArrayList();
                if (!method.isAnnotationPresent(RestDocAccept.class)) break block4;
                RestDocAccept docAccept = method.getAnnotation(RestDocAccept.class);
                for (RestDocType restDocType : types = docAccept.value()) {
                    if (!restDocType.schemaClass().equals(Object.class)) {
                        String schema = SchemaResolver.getSchemaFromType(restDocType.schemaClass(), this.schemaMap, this.ext);
                        list.add(new Representation(restDocType.type(), schema));
                        continue;
                    }
                    list.add(new Representation(restDocType.type(), restDocType.schema()));
                }
                break block5;
            }
            String[] mediaTypes = MediaTypeResolver.getConsumesMediaType(method);
            if (mediaTypes == null) break block5;
            for (int i = 0; i < parameterTypes.length; ++i) {
                Type param = parameterTypes[i];
                AnnotationMap map = new AnnotationMap(parameterAnnotations[i]);
                if (map.hasAnnotation(PathParam.class, QueryParam.class, HeaderParam.class)) continue;
                String schema = SchemaResolver.getSchemaFromType(param, this.schemaMap, this.ext);
                for (String mt : mediaTypes) {
                    list.add(new Representation(mt, schema));
                }
            }
        }
        return list;
    }

    private void parseRestDocParameter(ParamDefinition definition, RestDocParam docParam, Type paramType) {
        RestDocValidation[] restDocValidations;
        definition.setDescription(docParam.description());
        for (RestDocValidation validation : restDocValidations = docParam.validations()) {
            ParamValidation v = new ParamValidation();
            v.setType(validation.type());
            v.setPattern(validation.pattern());
            definition.getValidations().add(v);
        }
        if (paramType.equals(Long.class)) {
            definition.getValidations().add(new ParamValidation(VALIDATION_MATCH, PATTERN_SIGNED_INT));
        } else if (paramType.equals(Integer.class)) {
            definition.getValidations().add(new ParamValidation(VALIDATION_MATCH, PATTERN_SIGNED_INT));
        } else if (paramType.equals(Double.class)) {
            definition.getValidations().add(new ParamValidation(VALIDATION_MATCH, PATTERN_SIGNED_DECIMAL));
        } else if (paramType.equals(BigDecimal.class)) {
            definition.getValidations().add(new ParamValidation(VALIDATION_MATCH, PATTERN_SIGNED_DECIMAL));
        } else if (paramType.equals(Boolean.class)) {
            definition.getValidations().add(new ParamValidation(VALIDATION_MATCH, PATTERN_BOOL));
        } else if (paramType instanceof Class && ((Class)paramType).isEnum()) {
            List values = Arrays.asList(((Class)paramType).getEnumConstants());
            String join = Joiner.on((char)'|').join(values);
            definition.getValidations().add(new ParamValidation(VALIDATION_MATCH, join));
        }
    }

    private static String getHTTPVerb(Method method) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = method.getAnnotations()) {
            if (!annotation.annotationType().isAnnotationPresent(HttpMethod.class)) continue;
            HttpMethod httpMethod = annotation.annotationType().getAnnotation(HttpMethod.class);
            return httpMethod.value();
        }
        return null;
    }

    public String getRestDocStringForPath(String path) {
        if (!this.initialized.get()) {
            throw new RestDocException("Generator is not yet initialized");
        }
        try {
            RestDoc doc = this.getDoc(path);
            return RestDocParser.writeRestDoc((RestDoc)doc);
        }
        catch (IOException e) {
            throw new RestDocException(e);
        }
    }

    private RestDoc getDoc(String path) {
        RestDoc doc = new RestDoc();
        doc.setSchemas(new HashMap<String, Schema>(this.schemaMap));
        doc.getHeaders().getRequestHeader().putAll(this.requestHeaderMap);
        doc.getHeaders().getResponseHeader().putAll(this.responseHeaderMap);
        doc.getHeaders().getAdditionalFields().putAll(this.globalAdditional);
        Set<Map.Entry<String, RestResource>> entrySet = this.resources.entrySet();
        for (Map.Entry<String, RestResource> entry : entrySet) {
            if (!entry.getKey().startsWith(path)) continue;
            doc.getResources().add(entry.getValue());
        }
        this.ext.renderDoc(path, doc);
        return doc;
    }

    public void registerGeneratorExtension(IRestDocGeneratorExtension extension) {
        this.ext.exts.add(extension);
    }

    private class RDGEWrapper
    implements IRestDocGeneratorExtension {
        private final List<IRestDocGeneratorExtension> exts = new LinkedList<IRestDocGeneratorExtension>();

        private RDGEWrapper() {
        }

        @Override
        public void newResource(RestResource restResource) {
            for (IRestDocGeneratorExtension e : this.exts) {
                e.newResource(restResource);
            }
        }

        @Override
        public void queryParam(String name, ParamDefinition definition, Type paramType, AnnotationMap map) {
            for (IRestDocGeneratorExtension e : this.exts) {
                e.queryParam(name, definition, paramType, map);
            }
        }

        @Override
        public void pathParam(String name, ParamDefinition definition, Type paramType, AnnotationMap map) {
            for (IRestDocGeneratorExtension e : this.exts) {
                e.pathParam(name, definition, paramType, map);
            }
        }

        @Override
        public void headerParam(String name, HeaderDefinition definition, Type paramType, AnnotationMap map) {
            for (IRestDocGeneratorExtension e : this.exts) {
                e.headerParam(name, definition, paramType, map);
            }
        }

        @Override
        public void newMethod(RestResource restResource, MethodDefinition def, Method method) {
            for (IRestDocGeneratorExtension e : this.exts) {
                e.newMethod(restResource, def, method);
            }
        }

        @Override
        public void newSchema(String schemaURI, Schema s, Class<?> schemaClass) {
            for (IRestDocGeneratorExtension e : this.exts) {
                e.newSchema(schemaURI, s, schemaClass);
            }
        }

        @Override
        public void renderDoc(String path, RestDoc doc) {
            for (IRestDocGeneratorExtension e : this.exts) {
                e.renderDoc(path, doc);
            }
        }
    }
}

