/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.provisioning.number.vi;

import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.servlet.sip.SipURI;
import org.apache.commons.configuration.Configuration;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.log4j.Logger;
import org.restcomm.connect.commons.util.StringUtils;
import org.restcomm.connect.provisioning.number.api.ContainerConfiguration;
import org.restcomm.connect.provisioning.number.api.PhoneNumber;
import org.restcomm.connect.provisioning.number.api.PhoneNumberParameters;
import org.restcomm.connect.provisioning.number.api.PhoneNumberProvisioningManager;
import org.restcomm.connect.provisioning.number.api.PhoneNumberSearchFilters;
import org.restcomm.connect.provisioning.number.api.ProvisionProvider;
import org.restcomm.connect.provisioning.number.vi.GetDIDListResponse;
import org.restcomm.connect.provisioning.number.vi.LATA;
import org.restcomm.connect.provisioning.number.vi.NPA;
import org.restcomm.connect.provisioning.number.vi.NXX;
import org.restcomm.connect.provisioning.number.vi.RateCenter;
import org.restcomm.connect.provisioning.number.vi.State;
import org.restcomm.connect.provisioning.number.vi.TN;
import org.restcomm.connect.provisioning.number.vi.VoipInnovationsBody;
import org.restcomm.connect.provisioning.number.vi.VoipInnovationsHeader;
import org.restcomm.connect.provisioning.number.vi.VoipInnovationsResponse;
import org.restcomm.connect.provisioning.number.vi.converter.GetDIDListResponseConverter;
import org.restcomm.connect.provisioning.number.vi.converter.LATAConverter;
import org.restcomm.connect.provisioning.number.vi.converter.NPAConverter;
import org.restcomm.connect.provisioning.number.vi.converter.NXXConverter;
import org.restcomm.connect.provisioning.number.vi.converter.RateCenterConverter;
import org.restcomm.connect.provisioning.number.vi.converter.StateConverter;
import org.restcomm.connect.provisioning.number.vi.converter.TNConverter;
import org.restcomm.connect.provisioning.number.vi.converter.VoipInnovationsBodyConverter;
import org.restcomm.connect.provisioning.number.vi.converter.VoipInnovationsHeaderConverter;
import org.restcomm.connect.provisioning.number.vi.converter.VoipInnovationsResponseConverter;

public class VoIPInnovationsNumberProvisioningManager
implements PhoneNumberProvisioningManager {
    private static final Logger logger = Logger.getLogger(VoIPInnovationsNumberProvisioningManager.class);
    private XStream xstream;
    private String header;
    protected Boolean telestaxProxyEnabled;
    protected String uri;
    protected String username;
    protected String password;
    protected String endpoint;
    protected Configuration activeConfiguration;
    protected ContainerConfiguration containerConfiguration;

    public void init(Configuration phoneNumberProvisioningConfiguration, Configuration telestaxProxyConfiguration, ContainerConfiguration containerConfiguration) {
        this.containerConfiguration = containerConfiguration;
        this.telestaxProxyEnabled = telestaxProxyConfiguration.getBoolean("enabled", false);
        if (this.telestaxProxyEnabled.booleanValue()) {
            this.uri = telestaxProxyConfiguration.getString("uri");
            this.username = telestaxProxyConfiguration.getString("login");
            this.password = telestaxProxyConfiguration.getString("password");
            this.endpoint = telestaxProxyConfiguration.getString("endpoint");
            this.activeConfiguration = telestaxProxyConfiguration;
        } else {
            Configuration viConf = phoneNumberProvisioningConfiguration.subset("voip-innovations");
            this.uri = viConf.getString("uri");
            this.username = viConf.getString("login");
            this.password = viConf.getString("password");
            this.endpoint = viConf.getString("endpoint");
            this.activeConfiguration = viConf;
        }
        this.header = this.header(this.username, this.password);
        this.xstream = new XStream();
        this.xstream.alias("response", VoipInnovationsResponse.class);
        this.xstream.alias("header", VoipInnovationsHeader.class);
        this.xstream.alias("body", VoipInnovationsBody.class);
        this.xstream.alias("lata", LATAConverter.class);
        this.xstream.alias("npa", NPAConverter.class);
        this.xstream.alias("nxx", NXXConverter.class);
        this.xstream.alias("rate_center", RateCenterConverter.class);
        this.xstream.alias("state", StateConverter.class);
        this.xstream.alias("tn", TNConverter.class);
        this.xstream.registerConverter((Converter)new VoipInnovationsResponseConverter());
        this.xstream.registerConverter((Converter)new VoipInnovationsHeaderConverter());
        this.xstream.registerConverter((Converter)new VoipInnovationsBodyConverter());
        this.xstream.registerConverter((Converter)new GetDIDListResponseConverter());
        this.xstream.registerConverter((Converter)new LATAConverter());
        this.xstream.registerConverter((Converter)new NPAConverter());
        this.xstream.registerConverter((Converter)new NXXConverter());
        this.xstream.registerConverter((Converter)new RateCenterConverter());
        this.xstream.registerConverter((Converter)new StateConverter());
        this.xstream.registerConverter((Converter)new TNConverter());
    }

    private String header(String login, String password) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<header><sender>");
        buffer.append("<login>").append(login).append("</login>");
        buffer.append("<password>").append(password).append("</password>");
        buffer.append("</sender></header>");
        return buffer.toString();
    }

    private String getFriendlyName(String number) {
        try {
            PhoneNumberUtil phoneNumberUtil = PhoneNumberUtil.getInstance();
            Phonenumber.PhoneNumber phoneNumber = phoneNumberUtil.parse(number, "US");
            String friendlyName = phoneNumberUtil.format(phoneNumber, PhoneNumberUtil.PhoneNumberFormat.E164);
            return friendlyName;
        }
        catch (Exception ignored) {
            return number;
        }
    }

    private List<PhoneNumber> toAvailablePhoneNumbers(GetDIDListResponse response, PhoneNumberSearchFilters listFilters) {
        Pattern searchPattern = listFilters.getFilterPattern();
        ArrayList<PhoneNumber> numbers = new ArrayList<PhoneNumber>();
        List<State> states = response.states();
        for (State state : states) {
            if (listFilters.getInRegion() != null && (listFilters.getInRegion() == null || listFilters.getInRegion().isEmpty() || !listFilters.getInRegion().equals(state.name()))) continue;
            for (LATA lata : state.latas()) {
                for (RateCenter center : lata.centers()) {
                    for (NPA npa : center.npas()) {
                        for (NXX nxx : npa.nxxs()) {
                            for (TN tn : nxx.tns()) {
                                String name;
                                String phoneNumber = name = this.getFriendlyName(tn.number());
                                if (searchPattern != null && (searchPattern == null || !searchPattern.matcher(tn.number()).matches()) || listFilters.getFaxEnabled() != null && (listFilters.getFaxEnabled() == null || listFilters.getFaxEnabled().booleanValue() != tn.t38())) continue;
                                PhoneNumber number = new PhoneNumber(name, phoneNumber, Integer.valueOf(Integer.parseInt(lata.name())), center.name(), null, null, state.name(), null, "US", null, Boolean.valueOf(true), null, null, Boolean.valueOf(tn.t38()), null);
                                numbers.add(number);
                            }
                        }
                    }
                }
            }
        }
        return numbers;
    }

    public List<PhoneNumber> searchForNumbers(String country, PhoneNumberSearchFilters listFilters) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("searchPattern " + listFilters.getFilterPattern()));
        }
        String areaCode = listFilters.getAreaCode();
        Pattern filterPattern = listFilters.getFilterPattern();
        String searchPattern = null;
        if (filterPattern != null) {
            searchPattern = filterPattern.toString();
        }
        if (!(areaCode != null && areaCode.isEmpty() && areaCode.length() >= 3 || searchPattern == null || searchPattern.toString().isEmpty() || searchPattern.toString().length() < 5)) {
            areaCode = searchPattern.toString().substring(2, 5);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("areaCode derived from searchPattern " + searchPattern));
            }
        }
        if (areaCode != null && !areaCode.isEmpty() && areaCode.length() == 3) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("<request id=\"" + this.generateId() + "\">");
            buffer.append(this.header);
            buffer.append("<body>");
            buffer.append("<requesttype>").append("getDIDs").append("</requesttype>");
            buffer.append("<item>");
            buffer.append("<npa>").append(areaCode).append("</npa>");
            buffer.append("</item>");
            buffer.append("</body>");
            buffer.append("</request>");
            String body = buffer.toString();
            HttpPost post = new HttpPost(this.uri);
            ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
            parameters.add(new BasicNameValuePair("apidata", body));
            try {
                CloseableHttpResponse response;
                post.setEntity((HttpEntity)new UrlEncodedFormEntity(parameters));
                DefaultHttpClient client = new DefaultHttpClient();
                if (this.telestaxProxyEnabled.booleanValue()) {
                    this.addTelestaxProxyHeaders(post, ProvisionProvider.REQUEST_TYPE.GETDIDS.name());
                }
                if ((response = client.execute((HttpUriRequest)post)).getStatusLine().getStatusCode() == 200) {
                    String content = StringUtils.toString((InputStream)response.getEntity().getContent());
                    VoipInnovationsResponse result = (VoipInnovationsResponse)this.xstream.fromXML(content);
                    GetDIDListResponse dids = (GetDIDListResponse)result.body().content();
                    if (dids.code() == 100) {
                        List<PhoneNumber> numbers = this.toAvailablePhoneNumbers(dids, listFilters);
                        return numbers;
                    }
                } else {
                    logger.warn((Object)("Couldn't reach uri for getting DIDs. Response status was: " + response.getStatusLine().getStatusCode()));
                }
            }
            catch (Exception e) {
                logger.warn((Object)("Couldn't reach uri for getting DIDs " + this.uri), (Throwable)e);
            }
        }
        return new ArrayList<PhoneNumber>();
    }

    private String generateId() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public boolean buyNumber(PhoneNumber phoneNumberObject, PhoneNumberParameters phoneNumberParameters) {
        String phoneNumber = phoneNumberObject.getPhoneNumber();
        if (this.isValidDid(phoneNumber = phoneNumber.substring(2)) && phoneNumber != null && !phoneNumber.isEmpty()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("<request id=\"" + this.generateId() + "\">");
            buffer.append(this.header);
            buffer.append("<body>");
            buffer.append("<requesttype>").append("assignDID").append("</requesttype>");
            buffer.append("<item>");
            buffer.append("<did>").append(phoneNumber).append("</did>");
            buffer.append("<endpointgroup>").append(this.endpoint).append("</endpointgroup>");
            buffer.append("</item>");
            buffer.append("</body>");
            buffer.append("</request>");
            String body = buffer.toString();
            HttpPost post = new HttpPost(this.uri);
            try {
                String content;
                CloseableHttpResponse response;
                ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
                parameters.add(new BasicNameValuePair("apidata", body));
                post.setEntity((HttpEntity)new UrlEncodedFormEntity(parameters));
                DefaultHttpClient client = new DefaultHttpClient();
                if (this.telestaxProxyEnabled.booleanValue()) {
                    this.addTelestaxProxyHeaders(post, ProvisionProvider.REQUEST_TYPE.ASSIGNDID.name());
                }
                if ((response = client.execute((HttpUriRequest)post)).getStatusLine().getStatusCode() == 200 && (content = StringUtils.toString((InputStream)response.getEntity().getContent())).contains("<statuscode>100</statuscode>")) {
                    return true;
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        return false;
    }

    protected boolean isValidDid(String did) {
        if (did != null && !did.isEmpty()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("<request id=\"" + this.generateId() + "\">");
            buffer.append(this.header);
            buffer.append("<body>");
            buffer.append("<requesttype>").append("queryDID").append("</requesttype>");
            buffer.append("<item>");
            buffer.append("<did>").append(did).append("</did>");
            buffer.append("</item>");
            buffer.append("</body>");
            buffer.append("</request>");
            String body = buffer.toString();
            HttpPost post = new HttpPost(this.uri);
            try {
                String content;
                CloseableHttpResponse response;
                ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
                parameters.add(new BasicNameValuePair("apidata", body));
                post.setEntity((HttpEntity)new UrlEncodedFormEntity(parameters));
                DefaultHttpClient client = new DefaultHttpClient();
                if (this.telestaxProxyEnabled.booleanValue()) {
                    this.addTelestaxProxyHeaders(post, ProvisionProvider.REQUEST_TYPE.QUERYDID.name());
                }
                if ((response = client.execute((HttpUriRequest)post)).getStatusLine().getStatusCode() == 200 && (content = StringUtils.toString((InputStream)response.getEntity().getContent())).contains("<statusCode>100</statusCode>")) {
                    return true;
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean updateNumber(PhoneNumber phoneNumberObj, PhoneNumberParameters phoneNumberParameters) {
        return true;
    }

    public boolean cancelNumber(PhoneNumber phoneNumberObj) {
        String phoneNumber = phoneNumberObj.getPhoneNumber();
        String numberToRemoveFromVi = phoneNumber;
        if (numberToRemoveFromVi.startsWith("+1")) {
            numberToRemoveFromVi = numberToRemoveFromVi.replaceFirst("\\+1", "");
        }
        if (!this.isValidDid(phoneNumber = numberToRemoveFromVi)) {
            return false;
        }
        if (phoneNumber != null && !phoneNumber.isEmpty()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("<request id=\"" + this.generateId() + "\">");
            buffer.append(this.header);
            buffer.append("<body>");
            buffer.append("<requesttype>").append("releaseDID").append("</requesttype>");
            buffer.append("<item>");
            buffer.append("<did>").append(phoneNumber).append("</did>");
            buffer.append("</item>");
            buffer.append("</body>");
            buffer.append("</request>");
            String body = buffer.toString();
            HttpPost post = new HttpPost(this.uri);
            try {
                String content;
                CloseableHttpResponse response;
                ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
                parameters.add(new BasicNameValuePair("apidata", body));
                post.setEntity((HttpEntity)new UrlEncodedFormEntity(parameters));
                DefaultHttpClient client = new DefaultHttpClient();
                if (this.telestaxProxyEnabled.booleanValue()) {
                    this.addTelestaxProxyHeaders(post, ProvisionProvider.REQUEST_TYPE.RELEASEDID.name());
                }
                if ((response = client.execute((HttpUriRequest)post)).getStatusLine().getStatusCode() == 200 && (content = StringUtils.toString((InputStream)response.getEntity().getContent())).contains("<statuscode>100</statuscode>")) {
                    return true;
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        return false;
    }

    public List<String> getAvailableCountries() {
        ArrayList<String> countries = new ArrayList<String>();
        countries.add("US");
        return countries;
    }

    private void addTelestaxProxyHeaders(HttpPost post, String requestType) {
        post.addHeader("TelestaxProxy", "true");
        post.addHeader("Provider", ProvisionProvider.voipinnovationsClass);
        post.addHeader("RequestType", requestType);
        List uris = this.containerConfiguration.getOutboundInterfaces();
        for (SipURI uri : uris) {
            post.addHeader("OutboundIntf", uri.getHost() + ":" + uri.getPort() + ":" + uri.getTransportParam());
        }
    }
}

