/*
 * Decompiled with CFR 0.152.
 */
package org.researchstack.backbone.utils;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.support.v4.app.Fragment;
import android.text.InputFilter;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import java.lang.reflect.Constructor;

public class ViewUtils {
    private ViewUtils() {
    }

    public static InputFilter[] addFilter(InputFilter[] filters, InputFilter filter) {
        if (filters == null || filters.length == 0) {
            return new InputFilter[]{filter};
        }
        int size = filters.length;
        for (int i = 0; i < size; ++i) {
            if (!filters[i].getClass().isInstance(filter)) continue;
            filters[i] = filter;
            return filters;
        }
        int newSize = filters.length + 1;
        InputFilter[] newFilters = new InputFilter[newSize];
        System.arraycopy(filters, 0, newFilters, 0, filters.length);
        newFilters[newSize - 1] = filter;
        return newFilters;
    }

    public static void disableSoftInputFromAppearing(EditText editText) {
        if (Build.VERSION.SDK_INT >= 11) {
            editText.setRawInputType(1);
            editText.setTextIsSelectable(true);
        } else {
            editText.setRawInputType(0);
            editText.setFocusable(true);
        }
    }

    public static void hideSoftInputMethod(Context context) {
        View currentFocus;
        if (context instanceof Activity && (currentFocus = ((Activity)context).getCurrentFocus()) != null && currentFocus.getWindowToken() != null) {
            InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
            imm.hideSoftInputFromInputMethod(currentFocus.getWindowToken(), 2);
        }
    }

    public static void showSoftInputMethod(EditText editText) {
        editText.requestFocus();
        InputMethodManager imm = (InputMethodManager)editText.getContext().getSystemService("input_method");
        imm.showSoftInput((View)editText, 0);
    }

    public static Fragment createFragment(String className) {
        try {
            Class<?> fragmentClass = Class.forName(className);
            return ViewUtils.createFragment(fragmentClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static Fragment createFragment(Class fragmentClass) {
        try {
            Constructor fragConstructor = fragmentClass.getConstructor(new Class[0]);
            Object fragment = fragConstructor.newInstance(new Object[0]);
            return (Fragment)fragment;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

