/*
 * Decompiled with CFR 0.152.
 */
package org.researchstack.backbone.utils;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.TypedValue;
import java.lang.reflect.Method;
import org.researchstack.backbone.R;
import org.researchstack.backbone.utils.LogExt;

public class ThemeUtils {
    private ThemeUtils() {
    }

    public static int getTextColorPrimary(Context context) {
        TypedValue typedValue = new TypedValue();
        int[] attribute = new int[]{16842806};
        TypedArray array = context.obtainStyledAttributes(typedValue.resourceId, attribute);
        int color2 = array.getColor(0, -16777216);
        array.recycle();
        return color2;
    }

    public static int getAccentColor(Context context) {
        TypedValue typedValue = new TypedValue();
        TypedArray a = context.obtainStyledAttributes(typedValue.data, new int[]{R.attr.colorAccent});
        int color2 = a.getColor(0, 0);
        a.recycle();
        return color2;
    }

    public static int getPassCodeTheme(Context context) {
        TypedValue typedValue = new TypedValue();
        TypedArray a = context.obtainStyledAttributes(typedValue.data, new int[]{R.attr.passcodeTheme});
        int themeResId = a.getResourceId(0, 0);
        if (themeResId == 0) {
            throw new RuntimeException("Theme must define attribute passCodeTheme or extend from @style/Base.Theme.Backbone");
        }
        a.recycle();
        return themeResId;
    }

    public static int getTheme(Context context) {
        try {
            Class<Context> wrapper = Context.class;
            Method method = wrapper.getMethod("getThemeResId", new Class[0]);
            method.setAccessible(true);
            return (Integer)method.invoke((Object)context, new Object[0]);
        }
        catch (Exception e) {
            LogExt.e(ThemeUtils.class, e);
            return 0;
        }
    }
}

