/*
 * Decompiled with CFR 0.152.
 */
package org.researchstack.backbone.utils;

import android.text.InputFilter;
import android.text.Spanned;
import java.util.regex.Pattern;

public class TextUtils {
    public static final Pattern EMAIL_ADDRESS = Pattern.compile("[a-zA-Z0-9\\+\\.\\_\\%\\-\\+]{1,256}\\@[a-zA-Z0-9][a-zA-Z0-9\\-]{0,64}(\\.[a-zA-Z0-9][a-zA-Z0-9\\-]{0,25})+");

    private TextUtils() {
    }

    public static boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static boolean isValidEmail(CharSequence text) {
        return !TextUtils.isEmpty(text) && EMAIL_ADDRESS.matcher(text).matches();
    }

    public static class AlphanumericFilter
    implements InputFilter {
        public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
            for (int i = start; i < end; ++i) {
                if (Character.isLetterOrDigit(source.charAt(i))) continue;
                return "";
            }
            return null;
        }
    }

    public static class NumericFilter
    implements InputFilter {
        public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
            for (int i = start; i < end; ++i) {
                if (Character.isDigit(source.charAt(i))) continue;
                return "";
            }
            return null;
        }
    }

    public static class AlphabeticFilter
    implements InputFilter {
        public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
            for (int i = start; i < end; ++i) {
                if (Character.isLetter(source.charAt(i))) continue;
                return "";
            }
            return null;
        }
    }
}

