/*
 * Decompiled with CFR 0.152.
 */
package org.researchstack.backbone.utils;

import android.support.annotation.NonNull;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.researchstack.backbone.storage.file.StorageAccessException;

public class FileUtils {
    private FileUtils() {
    }

    public static void writeSafe(File file, byte[] data) {
        try {
            File tempFile = FileUtils.makeTempFile(file);
            FileOutputStream fileOutputStream = new FileOutputStream(tempFile);
            fileOutputStream.write(data);
            fileOutputStream.close();
            tempFile.renameTo(file);
        }
        catch (IOException e) {
            throw new StorageAccessException(e);
        }
    }

    @NonNull
    private static File makeTempFile(File localFile) {
        File temp = new File(localFile.getParentFile() + "/temp/" + localFile.getName() + ".temp");
        FileUtils.makeParent(temp);
        return temp;
    }

    public static void makeParent(File file) {
        File parent = file.getParentFile();
        if (parent != null && !parent.exists() && !parent.mkdirs()) {
            throw new StorageAccessException("Could not create parent dir of file: " + file.getPath());
        }
    }

    public static byte[] readAll(File file) throws IOException {
        int read;
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] buff = new byte[1024];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
        while ((read = fileInputStream.read(buff)) > 0) {
            byteArrayOutputStream.write(buff, 0, read);
        }
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream inputStream, File output) throws IOException {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(output);
            int read = 0;
            byte[] bytes = new byte[1024];
            while ((read = inputStream.read(bytes)) != -1) {
                ((OutputStream)outputStream).write(bytes, 0, read);
            }
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            finally {
                if (outputStream != null) {
                    ((OutputStream)outputStream).close();
                }
            }
        }
    }
}

