/*
 * Decompiled with CFR 0.152.
 */
package org.researchstack.backbone.ui.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.jakewharton.rxbinding.view.RxView;
import org.researchstack.backbone.R;
import org.researchstack.backbone.utils.ThemeUtils;
import rx.functions.Action1;

public class SubmitBar
extends LinearLayout {
    private TextView positiveView;
    private TextView negativeView;

    public SubmitBar(Context context) {
        this(context, null);
    }

    public SubmitBar(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.submitbarStyle);
    }

    public SubmitBar(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.rsb_view_submitbar, (ViewGroup)this, true);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SubmitBar, defStyleAttr, R.style.Widget_Backbone_SubmitBar);
        this.setBackground(a.getDrawable(R.styleable.SubmitBar_android_background));
        this.positiveView = (TextView)this.findViewById(R.id.bar_submit_postitive);
        this.positiveView.setText((CharSequence)a.getString(R.styleable.SubmitBar_positiveActionTitle));
        this.positiveView.setTextColor(a.getColor(R.styleable.SubmitBar_positiveActionColor, ThemeUtils.getAccentColor(context)));
        this.negativeView = (TextView)this.findViewById(R.id.bar_submit_negative);
        this.negativeView.setText((CharSequence)a.getString(R.styleable.SubmitBar_negativeActionTitle));
        this.negativeView.setTextColor(a.getColor(R.styleable.SubmitBar_negativeActionColor, ContextCompat.getColor((Context)context, (int)R.color.rsb_submit_bar_negative)));
        a.recycle();
    }

    public void setPositiveTitle(int title) {
        this.setPositiveTitle(this.getResources().getString(title));
    }

    public void setPositiveTitle(String title) {
        this.positiveView.setText((CharSequence)title);
    }

    public void setPositiveAction(Action1 submit) {
        RxView.clicks((View)this.positiveView).subscribe(submit);
    }

    public View getPositiveActionView() {
        return this.positiveView;
    }

    public void setNegativeTitle(int title) {
        this.setNegativeTitle(this.getResources().getString(title));
    }

    public void setNegativeTitle(String title) {
        this.negativeView.setText((CharSequence)title);
    }

    public void setNegativeAction(Action1 submit) {
        RxView.clicks((View)this.negativeView).subscribe(submit);
    }

    public View getNegativeActionView() {
        return this.negativeView;
    }
}

