/*
 * Decompiled with CFR 0.152.
 */
package org.researchstack.backbone.ui.views;

import android.animation.TimeInterpolator;
import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.view.inputmethod.InputMethodManager;
import android.widget.FrameLayout;
import java.security.InvalidParameterException;
import org.researchstack.backbone.R;
import org.researchstack.backbone.ui.step.layout.StepLayout;
import org.researchstack.backbone.ui.views.StepSwitcher$$Lambda$1;
import org.researchstack.backbone.ui.views.StepSwitcher$$Lambda$2;

public class StepSwitcher
extends FrameLayout {
    public static final DecelerateInterpolator interpolator = new DecelerateInterpolator(2.0f);
    public static final int SHIFT_LEFT = 1;
    public static final int SHIFT_RIGHT = -1;
    private int animationTime;

    public StepSwitcher(Context context) {
        super(context);
        this.init();
    }

    public StepSwitcher(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public StepSwitcher(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.animationTime = this.getResources().getInteger(R.integer.rsb_config_mediumAnimTime);
    }

    public void show(StepLayout stepLayout, int direction) {
        String stepLayoutId;
        String currentStepId;
        View currentStep = this.findViewById(R.id.rsb_current_step);
        if (currentStep != null && (currentStepId = (String)currentStep.getTag(R.id.rsb_step_layout_id)).equals(stepLayoutId = (String)stepLayout.getLayout().getTag(R.id.rsb_step_layout_id))) {
            return;
        }
        if (direction != 1 && direction != -1) {
            throw new InvalidParameterException("Direction with value: " + direction + " is not supported.");
        }
        this.post(StepSwitcher$$Lambda$1.lambdaFactory$(this, currentStep, stepLayout, direction));
    }

    private FrameLayout.LayoutParams getLayoutParams(StepLayout stepLayout) {
        FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)stepLayout.getLayout().getLayoutParams();
        if (lp == null) {
            lp = new FrameLayout.LayoutParams(-1, -1);
        }
        return lp;
    }

    public CharSequence getAccessibilityClassName() {
        return StepSwitcher.class.getName();
    }

    private /* synthetic */ void lambda$show$1(View currentStep, StepLayout stepLayout, int direction) {
        int currentIndex = 0;
        if (currentStep != null) {
            currentStep.setId(0);
            currentIndex = this.indexOfChild(currentStep);
        }
        FrameLayout.LayoutParams lp = this.getLayoutParams(stepLayout);
        this.addView(stepLayout.getLayout(), currentIndex, (ViewGroup.LayoutParams)lp);
        stepLayout.getLayout().setId(R.id.rsb_current_step);
        if (currentStep != null) {
            int newTranslationX = direction * this.getWidth();
            stepLayout.getLayout().setTranslationX((float)newTranslationX);
            stepLayout.getLayout().animate().setDuration((long)this.animationTime).setInterpolator((TimeInterpolator)interpolator).translationX(0.0f);
            currentStep.animate().setInterpolator((TimeInterpolator)interpolator).setDuration((long)this.animationTime).translationX((float)(-1 * newTranslationX)).withEndAction(StepSwitcher$$Lambda$2.lambdaFactory$(this, currentStep));
        }
    }

    private /* synthetic */ void lambda$null$0(View currentStep) {
        InputMethodManager imm = (InputMethodManager)this.getContext().getSystemService("input_method");
        if (imm.isActive() && imm.isAcceptingText()) {
            imm.toggleSoftInput(1, 0);
        }
        this.removeView(currentStep);
    }

    static /* synthetic */ void access$lambda$0(StepSwitcher stepSwitcher, View view, StepLayout stepLayout, int n) {
        stepSwitcher.lambda$show$1(view, stepLayout, n);
    }

    static /* synthetic */ void access$lambda$1(StepSwitcher stepSwitcher, View view) {
        stepSwitcher.lambda$null$0(view);
    }
}

