/*
 * Decompiled with CFR 0.152.
 */
package org.researchstack.backbone.ui.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.CornerPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.shapes.PathShape;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import java.util.ArrayList;
import java.util.List;
import org.researchstack.backbone.R;
import org.researchstack.backbone.ui.callbacks.SignatureCallbacks;

public class SignatureView
extends View {
    private static final boolean DEBUG = false;
    private static final String TAG = SignatureView.class.getSimpleName();
    private SignatureCallbacks callbacks;
    private List<LinePathPoint> sigPoints = new ArrayList<LinePathPoint>();
    private Path sigPath = new Path();
    private Paint sigPaint = new Paint();
    private Paint hintPaint = new Paint();
    private Rect drawBounds = new Rect();
    private String hintText;
    private int guidelineMargin;
    private int guidelineHeight;
    private int hintTextColor;
    private int guidelineColor;
    private int sigPrintColor;

    public SignatureView(Context context) {
        super(context);
        this.init(context, null, 0);
    }

    public SignatureView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0);
    }

    public SignatureView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, 0);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SignatureView, defStyleAttr, R.style.Widget_Backbone_SignatureView);
        int signatureColor = a.getColor(R.styleable.SignatureView_signatureColor, -16777216);
        this.sigPrintColor = a.getColor(R.styleable.SignatureView_signaturePrintColor, -16777216);
        int defSignatureStroke = (int)(this.getResources().getDisplayMetrics().density * 1.0f);
        int signatureStroke = a.getDimensionPixelSize(R.styleable.SignatureView_signatureStrokeSize, defSignatureStroke);
        this.hintText = a.getString(R.styleable.SignatureView_hintText);
        this.hintTextColor = a.getColor(R.styleable.SignatureView_hintTextColor, -3355444);
        int defHintTextSize = (int)(this.getResources().getDisplayMetrics().density * 14.0f);
        int hintTextSize = a.getDimensionPixelSize(R.styleable.SignatureView_hintTextSize, defHintTextSize);
        this.guidelineColor = a.getColor(R.styleable.SignatureView_guidelineColor, this.hintTextColor);
        int defGuidelineMargin = (int)(this.getResources().getDisplayMetrics().density * 12.0f);
        this.guidelineMargin = a.getDimensionPixelSize(R.styleable.SignatureView_guidelineMargin, defGuidelineMargin);
        int defGuidelineHeight = (int)(this.getResources().getDisplayMetrics().density * 1.0f);
        this.guidelineHeight = a.getDimensionPixelSize(R.styleable.SignatureView_guidelineHeight, defGuidelineHeight);
        a.recycle();
        this.sigPaint.setAntiAlias(true);
        this.sigPaint.setColor(signatureColor);
        this.sigPaint.setStyle(Paint.Style.STROKE);
        this.sigPaint.setStrokeJoin(Paint.Join.ROUND);
        this.sigPaint.setStrokeCap(Paint.Cap.ROUND);
        this.sigPaint.setPathEffect((PathEffect)new CornerPathEffect(20.0f));
        this.sigPaint.setStrokeWidth((float)signatureStroke);
        this.hintPaint.setAntiAlias(true);
        this.hintPaint.setColor(this.hintTextColor);
        this.hintPaint.setStyle(Paint.Style.FILL);
        this.hintPaint.setTextSize((float)hintTextSize);
    }

    public boolean onTouchEvent(MotionEvent event) {
        int x = (int)event.getX();
        int y = (int)event.getY();
        switch (event.getAction()) {
            case 0: {
                this.sigPoints.add(new LinePathPoint(x, y, 0));
                if (this.sigPath.isEmpty()) {
                    this.callbacks.onSignatureStarted();
                }
                this.sigPath.moveTo((float)x, (float)y);
                this.invalidate();
                break;
            }
            case 1: 
            case 2: {
                int hSize = event.getHistorySize();
                for (int i = 0; i < hSize; ++i) {
                    int hX = (int)event.getHistoricalX(i);
                    int hY = (int)event.getHistoricalY(i);
                    this.sigPath.lineTo((float)hX, (float)hY);
                    this.sigPoints.add(new LinePathPoint(x, y, 1));
                }
                this.sigPath.lineTo((float)x, (float)y);
                this.sigPoints.add(new LinePathPoint(x, y, 1));
                this.invalidate();
            }
        }
        return true;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.drawBounds.left = this.getPaddingLeft();
        this.drawBounds.top = this.getPaddingTop();
        this.drawBounds.right = w - this.getPaddingRight();
        this.drawBounds.bottom = h - this.getPaddingBottom();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.hintPaint.setColor(this.guidelineColor);
        canvas.drawRect((float)this.drawBounds.left, (float)(this.drawBounds.bottom - this.guidelineHeight), (float)this.drawBounds.right, (float)this.drawBounds.bottom, this.hintPaint);
        if (this.sigPath.isEmpty()) {
            this.hintPaint.setColor(this.hintTextColor);
            int baselineY = this.drawBounds.bottom - this.guidelineMargin - this.guidelineHeight;
            canvas.drawText(this.hintText, (float)this.drawBounds.left, (float)baselineY, this.hintPaint);
        } else {
            canvas.drawPath(this.sigPath, this.sigPaint);
        }
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SignatureSavedState ss = new SignatureSavedState(superState);
        ss.points = this.sigPoints;
        return ss;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SignatureSavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SignatureSavedState ss = (SignatureSavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.sigPoints = ss.points;
        this.sigPath.rewind();
        for (LinePathPoint point : this.sigPoints) {
            if (point.isStartPoint()) {
                this.sigPath.moveTo((float)point.x, (float)point.y);
                continue;
            }
            this.sigPath.lineTo((float)point.x, (float)point.y);
        }
    }

    public void clearSignature() {
        this.sigPath.rewind();
        this.sigPoints.clear();
        ViewCompat.postInvalidateOnAnimation((View)this);
        if (this.callbacks != null) {
            this.callbacks.onSignatureCleared();
        }
    }

    public boolean isSignatureDrawn() {
        return !this.sigPath.isEmpty();
    }

    public void setCallbacks(SignatureCallbacks callbacks) {
        this.callbacks = callbacks;
    }

    public Bitmap createSignatureBitmap() {
        Paint bitmapSigPaint = new Paint(this.sigPaint);
        bitmapSigPaint.setColor(this.sigPrintColor);
        RectF sigBounds = new RectF();
        this.sigPath.computeBounds(sigBounds, true);
        if (sigBounds.width() != 0.0f && sigBounds.height() != 0.0f) {
            float density = this.getResources().getDisplayMetrics().density;
            int dipWidth = (int)(sigBounds.width() / density);
            int dipHeight = (int)(sigBounds.height() / density);
            Bitmap returnedBitmap = Bitmap.createBitmap((int)dipWidth, (int)dipHeight, (Bitmap.Config)Bitmap.Config.ARGB_4444);
            float minX = 2.1474836E9f;
            float minY = 2.1474836E9f;
            for (LinePathPoint point : this.sigPoints) {
                minX = Math.min(minX, (float)point.x);
                minY = Math.min(minY, (float)point.y);
            }
            this.sigPath.offset(-minX, -minY);
            PathShape pathShape = new PathShape(this.sigPath, sigBounds.width(), sigBounds.height());
            pathShape.resize((float)dipWidth, (float)dipHeight);
            Canvas canvas = new Canvas(returnedBitmap);
            pathShape.draw(canvas, bitmapSigPaint);
            return returnedBitmap;
        }
        return null;
    }

    public static class LinePathPoint
    extends Point {
        public static final int TYPE_LINE_START = 0;
        public static final int TYPE_LINE_POINT = 1;
        private int type;
        public static final Parcelable.Creator<LinePathPoint> CREATOR = new Parcelable.Creator<LinePathPoint>(){

            public LinePathPoint createFromParcel(Parcel in) {
                LinePathPoint r = new LinePathPoint();
                r.readFromParcel(in);
                return r;
            }

            public LinePathPoint[] newArray(int size) {
                return new LinePathPoint[size];
            }
        };

        public LinePathPoint() {
        }

        public LinePathPoint(int x, int y, int type) {
            this.x = x;
            this.y = y;
            this.type = type;
        }

        public LinePathPoint(LinePathPoint src) {
            this.x = src.x;
            this.y = src.y;
            this.type = src.type;
        }

        public boolean isStartPoint() {
            return this.type == 0;
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.type);
        }

        public void readFromParcel(Parcel in) {
            super.readFromParcel(in);
            this.type = in.readInt();
        }
    }

    private static class SignatureSavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SignatureSavedState> CREATOR = new Parcelable.Creator<SignatureSavedState>(){

            public SignatureSavedState createFromParcel(Parcel in) {
                return new SignatureSavedState(in);
            }

            public SignatureSavedState[] newArray(int size) {
                return new SignatureSavedState[size];
            }
        };
        List<LinePathPoint> points;

        SignatureSavedState(Parcelable superState) {
            super(superState);
        }

        private SignatureSavedState(Parcel in) {
            super(in);
            this.points = new ArrayList<LinePathPoint>();
            in.readList(this.points, LinePathPoint.class.getClassLoader());
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeList(this.points);
        }
    }
}

