/*
 * Decompiled with CFR 0.152.
 */
package org.researchstack.backbone.ui.views;

import android.content.Context;
import android.support.annotation.CallSuper;
import android.text.InputFilter;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.RelativeLayout;
import android.widget.TextView;
import java.util.Arrays;
import org.researchstack.backbone.R;
import org.researchstack.backbone.StorageAccess;
import org.researchstack.backbone.storage.file.PinCodeConfig;
import org.researchstack.backbone.utils.ViewUtils;

public class PinCodeLayout
extends RelativeLayout {
    protected InputMethodManager imm;
    protected PinCodeConfig config;
    protected TextView summary;
    protected TextView title;
    protected EditText editText;
    protected View progress;

    public PinCodeLayout(Context context) {
        super(context);
        this.init();
    }

    public PinCodeLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public PinCodeLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    @CallSuper
    protected void init() {
        this.config = StorageAccess.getInstance().getPinCodeConfig();
        this.imm = (InputMethodManager)this.getContext().getSystemService("input_method");
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.rsb_step_layout_pincode, (ViewGroup)this, true);
        this.title = (TextView)this.findViewById(R.id.title);
        this.title.setText(R.string.rsb_pincode_enter_title);
        this.resetSummaryText();
        this.editText = (EditText)this.findViewById(R.id.pincode);
        this.editText.requestFocus();
        PinCodeConfig.Type pinType = this.config.getPinType();
        this.editText.setInputType(pinType.getInputType() | pinType.getVisibleVariationType(false));
        char[] chars = new char[this.config.getPinLength()];
        Arrays.fill(chars, '\u25e6');
        this.editText.setHint((CharSequence)new String(chars));
        InputFilter[] filters = ViewUtils.addFilter(this.editText.getFilters(), (InputFilter)new InputFilter.LengthFilter(this.config.getPinLength()));
        filters = ViewUtils.addFilter(filters, this.config.getPinType().getInputFilter());
        this.editText.setFilters(filters);
        this.progress = this.findViewById(R.id.progress);
    }

    public void resetSummaryText() {
        this.summary = (TextView)this.findViewById(R.id.text);
        String characterType = this.getContext().getString(this.config.getPinType().getInputTypeStringId());
        String pinCodeInstructions = this.getContext().getString(R.string.rsb_pincode_enter_summary, new Object[]{this.config.getPinLength(), characterType});
        this.summary.setText((CharSequence)pinCodeInstructions);
    }

    public void showProgress(boolean show) {
        this.progress.setVisibility(show ? 0 : 8);
    }
}

