/*
 * Decompiled with CFR 0.152.
 */
package org.researchstack.backbone.ui.views;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.util.AttributeSet;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import java.io.File;
import org.researchstack.backbone.ResourcePathManager;
import org.researchstack.backbone.ui.ViewVideoActivity;
import org.researchstack.backbone.ui.ViewWebDocumentActivity;
import org.researchstack.backbone.utils.LogExt;

public class LocalWebView
extends WebView {
    private static final String SCHEMA_LOCAL_HTML = "file:///android_asset/";
    private LocalWebViewCallbacks callbacks;

    public LocalWebView(Context context) {
        super(context);
        this.init();
    }

    public LocalWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public LocalWebView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.getSettings().setCacheMode(2);
        this.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                LogExt.i(((Object)((Object)this)).getClass(), url);
                if (url.startsWith(LocalWebView.SCHEMA_LOCAL_HTML)) {
                    int index = url.lastIndexOf(File.separatorChar);
                    String file = url.substring(index + 1);
                    if (file.endsWith(".pdf")) {
                        throw new UnsupportedOperationException("LocalWebView does not currently support viewing PDF files. Its suggested you generate HTML version of PDF for viewing");
                    }
                    if (file.endsWith(".mp4")) {
                        String fileName = file.substring(0, file.lastIndexOf("."));
                        String absVideoFilePath = ResourcePathManager.getInstance().generatePath(3, fileName);
                        Intent intent = ViewVideoActivity.newIntent(LocalWebView.this.getContext(), absVideoFilePath);
                        LocalWebView.this.getContext().startActivity(intent);
                    } else {
                        Intent intent = ViewWebDocumentActivity.newIntentForPath(LocalWebView.this.getContext(), null, url);
                        LocalWebView.this.getContext().startActivity(intent);
                    }
                } else {
                    Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
                    LocalWebView.this.getContext().startActivity(intent);
                }
                return true;
            }
        });
        this.setWebChromeClient(new WebChromeClient(){

            public void onReceivedTitle(WebView view, String title) {
                super.onReceivedTitle(view, title);
                if (LocalWebView.this.callbacks != null) {
                    LocalWebView.this.callbacks.onTitleLoaded(view.getTitle());
                }
            }
        });
    }

    public void setCallbacks(LocalWebViewCallbacks callbacks) {
        this.callbacks = callbacks;
    }

    public static interface LocalWebViewCallbacks {
        public void onTitleLoaded(String var1);
    }
}

