/*
 * Decompiled with CFR 0.152.
 */
package org.researchstack.backbone.ui.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.support.design.widget.TabLayout;
import android.util.AttributeSet;
import android.view.View;
import org.researchstack.backbone.R;
import org.researchstack.backbone.ui.views.IconTab;
import org.researchstack.backbone.ui.views.IconTabLayout$$Lambda$1;

public class IconTabLayout
extends TabLayout {
    private int tabIconColor = -1;
    private int tabIconIndicatorColor = -65536;
    private int tabTextColor = -1;

    public IconTabLayout(Context context) {
        this(context, null);
    }

    public IconTabLayout(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.icontablayoutStyle);
    }

    public IconTabLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.IconTabLayout, defStyleAttr, R.style.Widget_Backbone_IconTabLayout);
        Drawable background = a.getDrawable(R.styleable.IconTabLayout_android_background);
        this.setBackground(background);
        int minHeight = a.getDimensionPixelSize(R.styleable.IconTabLayout_android_minHeight, 0);
        this.setMinimumHeight(minHeight);
        this.tabIconColor = a.getColor(R.styleable.IconTabLayout_tabIconColor, this.tabIconColor);
        this.tabIconIndicatorColor = a.getColor(R.styleable.IconTabLayout_tabIconIndicatorColor, this.tabIconIndicatorColor);
        this.tabTextColor = a.getColor(R.styleable.IconTabLayout_tabTextColor, this.tabTextColor);
        a.recycle();
    }

    public TabLayout.Tab addIconTab(int title, int icon, boolean showIndicator, boolean isSelected) {
        TabLayout.Tab tabItem = this.newTab();
        IconTab iconTab = new IconTab(this.getContext());
        iconTab.setText(title);
        iconTab.setTextColor(this.tabTextColor);
        iconTab.setIcon(icon);
        iconTab.setIconTint(this.tabIconColor);
        iconTab.setIsIndicatorShow(showIndicator);
        iconTab.setIndicatorTint(this.tabIconIndicatorColor);
        iconTab.setSelected(isSelected);
        iconTab.setOnClickListener(IconTabLayout$$Lambda$1.lambdaFactory$(tabItem));
        tabItem.setCustomView((View)iconTab);
        if (isSelected) {
            tabItem.select();
        }
        this.addTab(tabItem);
        return tabItem;
    }

    static /* synthetic */ void access$lambda$0(TabLayout.Tab tab, View view) {
        tab.select();
    }

    public static class OnTabSelectedListenerAdapter
    implements TabLayout.OnTabSelectedListener {
        public void onTabSelected(TabLayout.Tab tab) {
        }

        public void onTabUnselected(TabLayout.Tab tab) {
        }

        public void onTabReselected(TabLayout.Tab tab) {
        }
    }
}

