/*
 * Decompiled with CFR 0.152.
 */
package org.researchstack.backbone.ui.views;

import android.animation.TimeInterpolator;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.StringRes;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.OvershootInterpolator;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import org.researchstack.backbone.R;
import org.researchstack.backbone.ui.views.IconTab$$Lambda$1;

public class IconTab
extends RelativeLayout
implements View.OnLongClickListener {
    private TextView title;
    private ImageView icon;
    private ImageView indicator;

    public IconTab(Context context) {
        super(context);
        this.init();
    }

    public IconTab(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public IconTab(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    @TargetApi(value=21)
    public IconTab(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    private void init() {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.rsb_view_icon_tab, (ViewGroup)this, true);
        this.title = (TextView)this.findViewById(R.id.title);
        this.icon = (ImageView)this.findViewById(R.id.icon);
        this.indicator = (ImageView)this.findViewById(R.id.indicator);
        this.adjustSelectedView();
        this.setOnLongClickListener(this);
    }

    public void dispatchSetSelected(boolean selected) {
        super.dispatchSetSelected(selected);
        this.adjustSelectedView();
    }

    private void adjustSelectedView() {
        if (this.getParent() == null) {
            this.icon.setAlpha(this.isSelected() ? 1.0f : 0.0f);
            this.title.setAlpha(this.isSelected() ? 0.0f : 1.0f);
            this.adjustIndicatorPosition();
        } else {
            this.indicator.animate().setStartDelay(0L).alpha(0.0f).withEndAction(IconTab$$Lambda$1.lambdaFactory$(this));
            this.icon.animate().alpha(this.isSelected() ? 1.0f : 0.0f).scaleX(this.isSelected() ? 1.0f : 0.0f).scaleY(this.isSelected() ? 1.0f : 0.0f).setDuration(150L).setInterpolator((TimeInterpolator)(this.isSelected() ? new OvershootInterpolator() : new AccelerateInterpolator())).setStartDelay(this.isSelected() ? 150L : 0L);
            this.title.animate().alpha(this.isSelected() ? 0.0f : 1.0f).setDuration(150L).setStartDelay(this.isSelected() ? 0L : 150L);
        }
    }

    private void adjustIndicatorPosition() {
        ImageView anchor = this.isSelected() ? this.icon : this.title;
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.indicator.getLayoutParams();
        params.addRule(6, anchor.getId());
        params.addRule(7, anchor.getId());
        this.indicator.requestLayout();
    }

    public void setText(@StringRes int textResId) {
        this.title.setText(textResId);
    }

    public void setTextColor(int textColor) {
        this.title.setTextColor(textColor);
    }

    public void setIcon(@DrawableRes int iconResId) {
        this.icon.setImageResource(iconResId);
    }

    public void setIcon(Drawable drawable2) {
        this.icon.setImageDrawable(drawable2);
    }

    public void setIconTint(int iconTint) {
        Drawable drawable2 = this.icon.getDrawable();
        drawable2 = DrawableCompat.wrap((Drawable)drawable2);
        DrawableCompat.setTint((Drawable)drawable2, (int)iconTint);
        this.icon.setImageDrawable(drawable2);
    }

    public void setIsIndicatorShow(boolean visible) {
        this.indicator.setVisibility(visible ? 0 : 4);
    }

    public void setIndicatorTint(int indicatorTint) {
        Drawable drawable2 = this.indicator.getDrawable();
        drawable2 = DrawableCompat.wrap((Drawable)drawable2);
        DrawableCompat.setTint((Drawable)drawable2, (int)indicatorTint);
        this.indicator.setImageDrawable(drawable2);
    }

    public boolean onLongClick(View v) {
        if (this.isSelected()) {
            int[] screenPos = new int[2];
            this.getLocationOnScreen(screenPos);
            Context context = this.getContext();
            int width = this.getWidth();
            int height = this.getHeight();
            int screenWidth = context.getResources().getDisplayMetrics().widthPixels;
            Toast cheatSheet = Toast.makeText((Context)context, (CharSequence)this.title.getText(), (int)0);
            cheatSheet.setGravity(49, screenPos[0] + width / 2 - screenWidth / 2, screenPos[1] + height);
            cheatSheet.show();
            return true;
        }
        return false;
    }

    private /* synthetic */ void lambda$adjustSelectedView$0() {
        this.adjustIndicatorPosition();
        this.indicator.animate().setStartDelay(200L).alpha(1.0f);
    }

    static /* synthetic */ void access$lambda$0(IconTab iconTab) {
        iconTab.lambda$adjustSelectedView$0();
    }
}

