/*
 * Decompiled with CFR 0.152.
 */
package org.researchstack.backbone.ui.views;

import android.annotation.TargetApi;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.widget.MediaController;
import android.widget.VideoView;
import java.io.FileDescriptor;
import java.io.IOException;
import org.researchstack.backbone.R;

public class AssetVideoView
extends SurfaceView
implements MediaController.MediaPlayerControl {
    private String TAG = "AssetVideoView";
    private FileDescriptor mFileDescriptor;
    private long mStartOffset;
    private long mLength;
    private static final int STATE_ERROR = -1;
    private static final int STATE_IDLE = 0;
    private static final int STATE_PREPARING = 1;
    private static final int STATE_PREPARED = 2;
    private static final int STATE_PLAYING = 3;
    private static final int STATE_PAUSED = 4;
    private static final int STATE_PLAYBACK_COMPLETED = 5;
    private int mCurrentState = 0;
    private int mTargetState = 0;
    private SurfaceHolder mSurfaceHolder = null;
    private MediaPlayer mMediaPlayer = null;
    private int mAudioSession;
    private int mVideoWidth;
    private int mVideoHeight;
    private int mSurfaceWidth;
    private int mSurfaceHeight;
    private MediaController mMediaController;
    private MediaPlayer.OnCompletionListener mOnCompletionListener;
    private MediaPlayer.OnPreparedListener mOnPreparedListener;
    private int mCurrentBufferPercentage;
    private MediaPlayer.OnErrorListener mOnErrorListener;
    private MediaPlayer.OnInfoListener mOnInfoListener;
    private int mSeekWhenPrepared;
    private boolean mCanPause;
    private boolean mCanSeekBack;
    private boolean mCanSeekForward;
    MediaPlayer.OnVideoSizeChangedListener mSizeChangedListener = new MediaPlayer.OnVideoSizeChangedListener(){

        public void onVideoSizeChanged(MediaPlayer mp, int width, int height) {
            AssetVideoView.this.mVideoWidth = mp.getVideoWidth();
            AssetVideoView.this.mVideoHeight = mp.getVideoHeight();
            if (AssetVideoView.this.mVideoWidth != 0 && AssetVideoView.this.mVideoHeight != 0) {
                AssetVideoView.this.getHolder().setFixedSize(AssetVideoView.this.mVideoWidth, AssetVideoView.this.mVideoHeight);
                AssetVideoView.this.requestLayout();
            }
        }
    };
    MediaPlayer.OnPreparedListener mPreparedListener = new MediaPlayer.OnPreparedListener(){

        public void onPrepared(MediaPlayer mp) {
            AssetVideoView.this.mCurrentState = 2;
            AssetVideoView.this.mCanPause = (AssetVideoView.this.mCanSeekBack = (AssetVideoView.this.mCanSeekForward = true));
            if (AssetVideoView.this.mOnPreparedListener != null) {
                AssetVideoView.this.mOnPreparedListener.onPrepared(AssetVideoView.this.mMediaPlayer);
            }
            if (AssetVideoView.this.mMediaController != null) {
                AssetVideoView.this.mMediaController.setEnabled(true);
            }
            AssetVideoView.this.mVideoWidth = mp.getVideoWidth();
            AssetVideoView.this.mVideoHeight = mp.getVideoHeight();
            int seekToPosition = AssetVideoView.this.mSeekWhenPrepared;
            if (seekToPosition != 0) {
                AssetVideoView.this.seekTo(seekToPosition);
            }
            if (AssetVideoView.this.mVideoWidth != 0 && AssetVideoView.this.mVideoHeight != 0) {
                AssetVideoView.this.getHolder().setFixedSize(AssetVideoView.this.mVideoWidth, AssetVideoView.this.mVideoHeight);
                if (AssetVideoView.this.mSurfaceWidth == AssetVideoView.this.mVideoWidth && AssetVideoView.this.mSurfaceHeight == AssetVideoView.this.mVideoHeight) {
                    if (AssetVideoView.this.mTargetState == 3) {
                        AssetVideoView.this.start();
                        if (AssetVideoView.this.mMediaController != null) {
                            AssetVideoView.this.mMediaController.show();
                        }
                    } else if (!(AssetVideoView.this.isPlaying() || seekToPosition == 0 && AssetVideoView.this.getCurrentPosition() <= 0 || AssetVideoView.this.mMediaController == null)) {
                        AssetVideoView.this.mMediaController.show(0);
                    }
                }
            } else if (AssetVideoView.this.mTargetState == 3) {
                AssetVideoView.this.start();
            }
        }
    };
    private MediaPlayer.OnCompletionListener mCompletionListener = new MediaPlayer.OnCompletionListener(){

        public void onCompletion(MediaPlayer mp) {
            AssetVideoView.this.mCurrentState = 5;
            AssetVideoView.this.mTargetState = 5;
            if (AssetVideoView.this.mMediaController != null) {
                AssetVideoView.this.mMediaController.hide();
            }
            if (AssetVideoView.this.mOnCompletionListener != null) {
                AssetVideoView.this.mOnCompletionListener.onCompletion(AssetVideoView.this.mMediaPlayer);
            }
        }
    };
    private MediaPlayer.OnInfoListener mInfoListener = new MediaPlayer.OnInfoListener(){

        public boolean onInfo(MediaPlayer mp, int arg1, int arg2) {
            if (AssetVideoView.this.mOnInfoListener != null) {
                AssetVideoView.this.mOnInfoListener.onInfo(mp, arg1, arg2);
            }
            return true;
        }
    };
    private MediaPlayer.OnErrorListener mErrorListener = new MediaPlayer.OnErrorListener(){

        public boolean onError(MediaPlayer mp, int framework_err, int impl_err) {
            Log.d((String)AssetVideoView.this.TAG, (String)("Error: " + framework_err + "," + impl_err));
            AssetVideoView.this.mCurrentState = -1;
            AssetVideoView.this.mTargetState = -1;
            if (AssetVideoView.this.mMediaController != null) {
                AssetVideoView.this.mMediaController.hide();
            }
            if (AssetVideoView.this.mOnErrorListener != null && AssetVideoView.this.mOnErrorListener.onError(AssetVideoView.this.mMediaPlayer, framework_err, impl_err)) {
                return true;
            }
            if (AssetVideoView.this.getWindowToken() != null) {
                Resources r = AssetVideoView.this.getContext().getResources();
                int messageId = framework_err == 200 ? R.string.rsb_error_assetvideoview_invalid_progressive_playback : R.string.rsb_error_assetvideoview_unknown;
                new AlertDialog.Builder(AssetVideoView.this.getContext()).setMessage(messageId).setPositiveButton(R.string.rsb_error_assetvideoview_button, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int whichButton) {
                        if (AssetVideoView.this.mOnCompletionListener != null) {
                            AssetVideoView.this.mOnCompletionListener.onCompletion(AssetVideoView.this.mMediaPlayer);
                        }
                    }
                }).setCancelable(false).show();
            }
            return true;
        }
    };
    private MediaPlayer.OnBufferingUpdateListener mBufferingUpdateListener = new MediaPlayer.OnBufferingUpdateListener(){

        public void onBufferingUpdate(MediaPlayer mp, int percent) {
            AssetVideoView.this.mCurrentBufferPercentage = percent;
        }
    };
    SurfaceHolder.Callback mSHCallback = new SurfaceHolder.Callback(){

        public void surfaceChanged(SurfaceHolder holder, int format, int w, int h) {
            boolean hasValidSize;
            AssetVideoView.this.mSurfaceWidth = w;
            AssetVideoView.this.mSurfaceHeight = h;
            boolean isValidState = AssetVideoView.this.mTargetState == 3;
            boolean bl = hasValidSize = AssetVideoView.this.mVideoWidth == w && AssetVideoView.this.mVideoHeight == h;
            if (AssetVideoView.this.mMediaPlayer != null && isValidState && hasValidSize) {
                if (AssetVideoView.this.mSeekWhenPrepared != 0) {
                    AssetVideoView.this.seekTo(AssetVideoView.this.mSeekWhenPrepared);
                }
                AssetVideoView.this.start();
            }
        }

        public void surfaceCreated(SurfaceHolder holder) {
            AssetVideoView.this.mSurfaceHolder = holder;
            AssetVideoView.this.openVideo();
        }

        public void surfaceDestroyed(SurfaceHolder holder) {
            AssetVideoView.this.mSurfaceHolder = null;
            if (AssetVideoView.this.mMediaController != null) {
                AssetVideoView.this.mMediaController.hide();
            }
            AssetVideoView.this.release(true);
        }
    };

    public AssetVideoView(Context context) {
        super(context);
        this.initVideoView();
    }

    public AssetVideoView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
        this.initVideoView();
    }

    public AssetVideoView(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    @TargetApi(value=21)
    public AssetVideoView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initVideoView();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = AssetVideoView.getDefaultSize((int)this.mVideoWidth, (int)widthMeasureSpec);
        int height = AssetVideoView.getDefaultSize((int)this.mVideoHeight, (int)heightMeasureSpec);
        if (this.mVideoWidth > 0 && this.mVideoHeight > 0) {
            int widthSpecMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
            int widthSpecSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int heightSpecMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
            int heightSpecSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
            if (widthSpecMode == 0x40000000 && heightSpecMode == 0x40000000) {
                height = heightSpecSize;
                width = widthSpecSize;
                if (this.mVideoWidth * height < width * this.mVideoHeight) {
                    width = height * this.mVideoWidth / this.mVideoHeight;
                } else if (this.mVideoWidth * height > width * this.mVideoHeight) {
                    height = width * this.mVideoHeight / this.mVideoWidth;
                }
            } else if (widthSpecMode == 0x40000000) {
                width = widthSpecSize;
                height = width * this.mVideoHeight / this.mVideoWidth;
                if (heightSpecMode == Integer.MIN_VALUE && height > heightSpecSize) {
                    height = heightSpecSize;
                }
            } else if (heightSpecMode == 0x40000000) {
                height = heightSpecSize;
                width = height * this.mVideoWidth / this.mVideoHeight;
                if (widthSpecMode == Integer.MIN_VALUE && width > widthSpecSize) {
                    width = widthSpecSize;
                }
            } else {
                width = this.mVideoWidth;
                height = this.mVideoHeight;
                if (heightSpecMode == Integer.MIN_VALUE && height > heightSpecSize) {
                    height = heightSpecSize;
                    width = height * this.mVideoWidth / this.mVideoHeight;
                }
                if (widthSpecMode == Integer.MIN_VALUE && width > widthSpecSize) {
                    width = widthSpecSize;
                    height = width * this.mVideoHeight / this.mVideoWidth;
                }
            }
        }
        this.setMeasuredDimension(width, height);
    }

    public CharSequence getAccessibilityClassName() {
        return VideoView.class.getName();
    }

    public int resolveAdjustedSize(int desiredSize, int measureSpec) {
        return AssetVideoView.getDefaultSize((int)desiredSize, (int)measureSpec);
    }

    private void initVideoView() {
        this.mVideoWidth = 0;
        this.mVideoHeight = 0;
        this.getHolder().addCallback(this.mSHCallback);
        this.getHolder().setType(3);
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.requestFocus();
        this.mCurrentState = 0;
        this.mTargetState = 0;
    }

    public void setVideoDataSource(FileDescriptor fileDescriptor, long startOffset, long length) {
        this.mFileDescriptor = fileDescriptor;
        this.mStartOffset = startOffset;
        this.mLength = length;
        this.mSeekWhenPrepared = 0;
        this.openVideo();
        this.requestLayout();
        this.invalidate();
    }

    public void stopPlayback() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.stop();
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
            this.mCurrentState = 0;
            this.mTargetState = 0;
            AudioManager am = (AudioManager)this.getContext().getSystemService("audio");
            am.abandonAudioFocus(null);
        }
    }

    private void openVideo() {
        if (this.mFileDescriptor == null || this.mSurfaceHolder == null) {
            return;
        }
        this.release(false);
        AudioManager am = (AudioManager)this.getContext().getSystemService("audio");
        am.requestAudioFocus(null, 3, 1);
        try {
            this.mMediaPlayer = new MediaPlayer();
            if (this.mAudioSession != 0) {
                this.mMediaPlayer.setAudioSessionId(this.mAudioSession);
            } else {
                this.mAudioSession = this.mMediaPlayer.getAudioSessionId();
            }
            this.mMediaPlayer.setOnPreparedListener(this.mPreparedListener);
            this.mMediaPlayer.setOnVideoSizeChangedListener(this.mSizeChangedListener);
            this.mMediaPlayer.setOnCompletionListener(this.mCompletionListener);
            this.mMediaPlayer.setOnErrorListener(this.mErrorListener);
            this.mMediaPlayer.setOnInfoListener(this.mInfoListener);
            this.mMediaPlayer.setOnBufferingUpdateListener(this.mBufferingUpdateListener);
            this.mCurrentBufferPercentage = 0;
            this.mMediaPlayer.setDataSource(this.mFileDescriptor, this.mStartOffset, this.mLength);
            this.mMediaPlayer.setDisplay(this.mSurfaceHolder);
            this.mMediaPlayer.setAudioStreamType(3);
            this.mMediaPlayer.setScreenOnWhilePlaying(true);
            this.mMediaPlayer.prepareAsync();
            this.mCurrentState = 1;
            this.attachMediaController();
        }
        catch (IOException | IllegalArgumentException ex) {
            Log.w((String)this.TAG, (String)("Unable to open content: " + this.mFileDescriptor), (Throwable)ex);
            this.mCurrentState = -1;
            this.mTargetState = -1;
            this.mErrorListener.onError(this.mMediaPlayer, 1, 0);
            return;
        }
    }

    public void setMediaController(MediaController controller) {
        if (this.mMediaController != null) {
            this.mMediaController.hide();
        }
        this.mMediaController = controller;
        this.attachMediaController();
    }

    private void attachMediaController() {
        if (this.mMediaPlayer != null && this.mMediaController != null) {
            this.mMediaController.setMediaPlayer((MediaController.MediaPlayerControl)this);
            AssetVideoView anchorView = this.getParent() instanceof View ? (View)this.getParent() : this;
            this.mMediaController.setAnchorView((View)anchorView);
            this.mMediaController.setEnabled(this.isInPlaybackState());
        }
    }

    public void setOnPreparedListener(MediaPlayer.OnPreparedListener l) {
        this.mOnPreparedListener = l;
    }

    public void setOnCompletionListener(MediaPlayer.OnCompletionListener l) {
        this.mOnCompletionListener = l;
    }

    public void setOnErrorListener(MediaPlayer.OnErrorListener l) {
        this.mOnErrorListener = l;
    }

    public void setOnInfoListener(MediaPlayer.OnInfoListener l) {
        this.mOnInfoListener = l;
    }

    private void release(boolean cleartargetstate) {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.reset();
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
            this.mCurrentState = 0;
            if (cleartargetstate) {
                this.mTargetState = 0;
            }
            AudioManager am = (AudioManager)this.getContext().getSystemService("audio");
            am.abandonAudioFocus(null);
        }
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.isInPlaybackState() && this.mMediaController != null) {
            this.toggleMediaControlsVisiblity();
        }
        return false;
    }

    public boolean onTrackballEvent(MotionEvent ev) {
        if (this.isInPlaybackState() && this.mMediaController != null) {
            this.toggleMediaControlsVisiblity();
        }
        return false;
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        boolean isKeyCodeSupported;
        boolean bl = isKeyCodeSupported = keyCode != 4 && keyCode != 24 && keyCode != 25 && keyCode != 164 && keyCode != 82 && keyCode != 5 && keyCode != 6;
        if (this.isInPlaybackState() && isKeyCodeSupported && this.mMediaController != null) {
            if (keyCode == 79 || keyCode == 85) {
                if (this.mMediaPlayer.isPlaying()) {
                    this.pause();
                    this.mMediaController.show();
                } else {
                    this.start();
                    this.mMediaController.hide();
                }
                return true;
            }
            if (keyCode == 126) {
                if (!this.mMediaPlayer.isPlaying()) {
                    this.start();
                    this.mMediaController.hide();
                }
                return true;
            }
            if (keyCode == 86 || keyCode == 127) {
                if (this.mMediaPlayer.isPlaying()) {
                    this.pause();
                    this.mMediaController.show();
                }
                return true;
            }
            this.toggleMediaControlsVisiblity();
        }
        return super.onKeyDown(keyCode, event);
    }

    private void toggleMediaControlsVisiblity() {
        if (this.mMediaController.isShowing()) {
            this.mMediaController.hide();
        } else {
            this.mMediaController.show();
        }
    }

    public void start() {
        if (this.isInPlaybackState()) {
            this.mMediaPlayer.start();
            this.mCurrentState = 3;
        }
        this.mTargetState = 3;
    }

    public void pause() {
        if (this.isInPlaybackState() && this.mMediaPlayer.isPlaying()) {
            this.mMediaPlayer.pause();
            this.mCurrentState = 4;
        }
        this.mTargetState = 4;
    }

    public void suspend() {
        this.release(false);
    }

    public void resume() {
        this.openVideo();
    }

    public int getDuration() {
        if (this.isInPlaybackState()) {
            return this.mMediaPlayer.getDuration();
        }
        return -1;
    }

    public int getCurrentPosition() {
        if (this.isInPlaybackState()) {
            return this.mMediaPlayer.getCurrentPosition();
        }
        return 0;
    }

    public void seekTo(int msec) {
        if (this.isInPlaybackState()) {
            this.mMediaPlayer.seekTo(msec);
            this.mSeekWhenPrepared = 0;
        } else {
            this.mSeekWhenPrepared = msec;
        }
    }

    public boolean isPlaying() {
        return this.isInPlaybackState() && this.mMediaPlayer.isPlaying();
    }

    public int getBufferPercentage() {
        if (this.mMediaPlayer != null) {
            return this.mCurrentBufferPercentage;
        }
        return 0;
    }

    private boolean isInPlaybackState() {
        return this.mMediaPlayer != null && this.mCurrentState != -1 && this.mCurrentState != 0 && this.mCurrentState != 1;
    }

    public boolean canPause() {
        return this.mCanPause;
    }

    public boolean canSeekBackward() {
        return this.mCanSeekBack;
    }

    public boolean canSeekForward() {
        return this.mCanSeekForward;
    }

    public int getAudioSessionId() {
        if (this.mAudioSession == 0) {
            MediaPlayer foo = new MediaPlayer();
            this.mAudioSession = foo.getAudioSessionId();
            foo.release();
        }
        return this.mAudioSession;
    }
}

