/*
 * Decompiled with CFR 0.152.
 */
package org.researchstack.backbone.ui.step.layout;

import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.StringRes;
import android.text.Html;
import android.text.method.MovementMethod;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import java.lang.reflect.Constructor;
import org.researchstack.backbone.R;
import org.researchstack.backbone.ResourcePathManager;
import org.researchstack.backbone.result.StepResult;
import org.researchstack.backbone.step.QuestionStep;
import org.researchstack.backbone.step.Step;
import org.researchstack.backbone.ui.ViewWebDocumentActivity;
import org.researchstack.backbone.ui.callbacks.StepCallbacks;
import org.researchstack.backbone.ui.step.body.BodyAnswer;
import org.researchstack.backbone.ui.step.body.StepBody;
import org.researchstack.backbone.ui.step.layout.StepLayout;
import org.researchstack.backbone.ui.step.layout.SurveyStepLayout$$Lambda$1;
import org.researchstack.backbone.ui.step.layout.SurveyStepLayout$$Lambda$2;
import org.researchstack.backbone.ui.step.layout.TextViewLinkHandler;
import org.researchstack.backbone.ui.views.FixedSubmitBarLayout;
import org.researchstack.backbone.ui.views.SubmitBar;
import org.researchstack.backbone.utils.LogExt;
import org.researchstack.backbone.utils.TextUtils;

public class SurveyStepLayout
extends FixedSubmitBarLayout
implements StepLayout {
    public static final String TAG = SurveyStepLayout.class.getSimpleName();
    private QuestionStep questionStep;
    private StepResult stepResult;
    private StepCallbacks callbacks;
    private LinearLayout container;
    private StepBody stepBody;

    public SurveyStepLayout(Context context) {
        super(context);
    }

    public SurveyStepLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public SurveyStepLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void initialize(Step step) {
        this.initialize(step, null);
    }

    @Override
    public void initialize(Step step, StepResult result) {
        if (!(step instanceof QuestionStep)) {
            throw new RuntimeException("Step being used in SurveyStep is not a QuestionStep");
        }
        this.questionStep = (QuestionStep)step;
        this.stepResult = result;
        this.initializeStep();
    }

    @Override
    public View getLayout() {
        return this;
    }

    @Override
    public boolean isBackEventConsumed() {
        this.callbacks.onSaveStep(-1, this.getStep(), this.stepBody.getStepResult(false));
        return false;
    }

    @Override
    public void setCallbacks(StepCallbacks callbacks) {
        this.callbacks = callbacks;
    }

    @Override
    public int getContentResourceId() {
        return R.layout.rsb_step_layout;
    }

    public void initializeStep() {
        this.initStepLayout();
        this.initStepBody();
    }

    public void initStepLayout() {
        LogExt.i(this.getClass(), "initStepLayout()");
        this.container = (LinearLayout)this.findViewById(R.id.rsb_survey_content_container);
        TextView title = (TextView)this.findViewById(R.id.rsb_survey_title);
        TextView summary = (TextView)this.findViewById(R.id.rsb_survey_text);
        SubmitBar submitBar = (SubmitBar)this.findViewById(R.id.rsb_submit_bar);
        submitBar.setPositiveAction(SurveyStepLayout$$Lambda$1.lambdaFactory$(this));
        if (this.questionStep != null) {
            if (!TextUtils.isEmpty(this.questionStep.getTitle())) {
                title.setVisibility(0);
                title.setText((CharSequence)this.questionStep.getTitle());
            }
            if (!TextUtils.isEmpty(this.questionStep.getText())) {
                summary.setVisibility(0);
                summary.setText((CharSequence)Html.fromHtml((String)this.questionStep.getText()));
                summary.setMovementMethod((MovementMethod)new TextViewLinkHandler(){

                    @Override
                    public void onLinkClick(String url) {
                        String path = ResourcePathManager.getInstance().generateAbsolutePath(0, url);
                        Intent intent = ViewWebDocumentActivity.newIntentForPath(SurveyStepLayout.this.getContext(), SurveyStepLayout.this.questionStep.getTitle(), path);
                        SurveyStepLayout.this.getContext().startActivity(intent);
                    }
                });
            }
            if (this.questionStep.isOptional()) {
                submitBar.setNegativeTitle(R.string.rsb_step_skip);
                submitBar.setNegativeAction(SurveyStepLayout$$Lambda$2.lambdaFactory$(this));
            } else {
                submitBar.getNegativeActionView().setVisibility(8);
            }
        }
    }

    public void initStepBody() {
        LogExt.i(this.getClass(), "initStepBody()");
        LayoutInflater inflater = LayoutInflater.from((Context)this.getContext());
        this.stepBody = this.createStepBody(this.questionStep, this.stepResult);
        View body = this.stepBody.getBodyView(0, inflater, (ViewGroup)this);
        if (body != null) {
            View oldView = this.container.findViewById(R.id.rsb_survey_step_body);
            int bodyIndex = this.container.indexOfChild(oldView);
            this.container.removeView(oldView);
            this.container.addView(body, bodyIndex);
            body.setId(R.id.rsb_survey_step_body);
        }
    }

    @NonNull
    private StepBody createStepBody(QuestionStep questionStep, StepResult result) {
        try {
            Class<?> cls = questionStep.getStepBodyClass();
            Constructor<?> constructor = cls.getConstructor(Step.class, StepResult.class);
            return (StepBody)constructor.newInstance(questionStep, result);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Parcelable onSaveInstanceState() {
        this.callbacks.onSaveStep(0, this.getStep(), this.stepBody.getStepResult(false));
        return super.onSaveInstanceState();
    }

    protected void onNextClicked() {
        BodyAnswer bodyAnswer = this.stepBody.getBodyAnswerState();
        if (bodyAnswer == null || !bodyAnswer.isValid()) {
            Toast.makeText((Context)this.getContext(), (CharSequence)(bodyAnswer == null ? BodyAnswer.INVALID.getString(this.getContext()) : bodyAnswer.getString(this.getContext())), (int)0).show();
        } else {
            this.callbacks.onSaveStep(1, this.getStep(), this.stepBody.getStepResult(false));
        }
    }

    public void onSkipClicked() {
        if (this.callbacks != null) {
            this.callbacks.onSaveStep(1, this.getStep(), this.stepBody.getStepResult(true));
        }
    }

    public Step getStep() {
        return this.questionStep;
    }

    public String getString(@StringRes int stringResId) {
        return this.getResources().getString(stringResId);
    }

    private /* synthetic */ void lambda$initStepLayout$1(Object v) {
        this.onSkipClicked();
    }

    private /* synthetic */ void lambda$initStepLayout$0(Object v) {
        this.onNextClicked();
    }

    static /* synthetic */ void access$lambda$0(SurveyStepLayout surveyStepLayout, Object object) {
        surveyStepLayout.lambda$initStepLayout$0(object);
    }

    static /* synthetic */ void access$lambda$1(SurveyStepLayout surveyStepLayout, Object object) {
        surveyStepLayout.lambda$initStepLayout$1(object);
    }
}

