/*
 * Decompiled with CFR 0.152.
 */
package org.researchstack.backbone.ui.step.layout;

import android.content.Context;
import android.content.Intent;
import android.text.Html;
import android.text.method.MovementMethod;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;
import org.researchstack.backbone.R;
import org.researchstack.backbone.ResourcePathManager;
import org.researchstack.backbone.result.StepResult;
import org.researchstack.backbone.step.Step;
import org.researchstack.backbone.ui.ViewWebDocumentActivity;
import org.researchstack.backbone.ui.callbacks.StepCallbacks;
import org.researchstack.backbone.ui.step.layout.InstructionStepLayout$$Lambda$1;
import org.researchstack.backbone.ui.step.layout.InstructionStepLayout$$Lambda$2;
import org.researchstack.backbone.ui.step.layout.StepLayout;
import org.researchstack.backbone.ui.step.layout.TextViewLinkHandler;
import org.researchstack.backbone.ui.views.FixedSubmitBarLayout;
import org.researchstack.backbone.ui.views.SubmitBar;
import org.researchstack.backbone.utils.TextUtils;

public class InstructionStepLayout
extends FixedSubmitBarLayout
implements StepLayout {
    private StepCallbacks callbacks;
    private Step step;

    public InstructionStepLayout(Context context) {
        super(context);
    }

    public InstructionStepLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public InstructionStepLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    public void initialize(Step step, StepResult result) {
        this.step = step;
        this.initializeStep();
    }

    @Override
    public View getLayout() {
        return this;
    }

    @Override
    public boolean isBackEventConsumed() {
        this.callbacks.onSaveStep(-1, this.step, null);
        return false;
    }

    @Override
    public void setCallbacks(StepCallbacks callbacks) {
        this.callbacks = callbacks;
    }

    @Override
    public int getContentResourceId() {
        return R.layout.rsb_step_layout_instruction;
    }

    private void initializeStep() {
        if (this.step != null) {
            if (!TextUtils.isEmpty(this.step.getTitle())) {
                TextView title = (TextView)this.findViewById(R.id.rsb_intruction_title);
                title.setVisibility(0);
                title.setText((CharSequence)this.step.getTitle());
            }
            if (!TextUtils.isEmpty(this.step.getText())) {
                TextView summary = (TextView)this.findViewById(R.id.rsb_intruction_text);
                summary.setVisibility(0);
                summary.setText((CharSequence)Html.fromHtml((String)this.step.getText()));
                summary.setMovementMethod((MovementMethod)new TextViewLinkHandler(){

                    @Override
                    public void onLinkClick(String url) {
                        String path = ResourcePathManager.getInstance().generateAbsolutePath(0, url);
                        Intent intent = ViewWebDocumentActivity.newIntentForPath(InstructionStepLayout.this.getContext(), InstructionStepLayout.this.step.getTitle(), path);
                        InstructionStepLayout.this.getContext().startActivity(intent);
                    }
                });
            }
            SubmitBar submitBar = (SubmitBar)this.findViewById(R.id.rsb_submit_bar);
            submitBar.setPositiveTitle(R.string.rsb_next);
            submitBar.setPositiveAction(InstructionStepLayout$$Lambda$1.lambdaFactory$(this));
            if (this.step.isOptional()) {
                submitBar.setNegativeTitle(R.string.rsb_step_skip);
                submitBar.setNegativeAction(InstructionStepLayout$$Lambda$2.lambdaFactory$(this));
            } else {
                submitBar.getNegativeActionView().setVisibility(8);
            }
        }
    }

    private /* synthetic */ void lambda$initializeStep$1(Object v) {
        if (this.callbacks != null) {
            this.callbacks.onSaveStep(1, this.step, null);
        }
    }

    private /* synthetic */ void lambda$initializeStep$0(Object v) {
        this.callbacks.onSaveStep(1, this.step, null);
    }

    static /* synthetic */ void access$lambda$0(InstructionStepLayout instructionStepLayout, Object object) {
        instructionStepLayout.lambda$initializeStep$0(object);
    }

    static /* synthetic */ void access$lambda$1(InstructionStepLayout instructionStepLayout, Object object) {
        instructionStepLayout.lambda$initializeStep$1(object);
    }
}

