/*
 * Decompiled with CFR 0.152.
 */
package org.researchstack.backbone.ui.step.layout;

import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.jakewharton.rxbinding.view.RxView;
import org.researchstack.backbone.R;
import org.researchstack.backbone.model.ConsentSection;
import org.researchstack.backbone.result.StepResult;
import org.researchstack.backbone.step.ConsentVisualStep;
import org.researchstack.backbone.step.Step;
import org.researchstack.backbone.ui.ViewWebDocumentActivity;
import org.researchstack.backbone.ui.callbacks.StepCallbacks;
import org.researchstack.backbone.ui.step.layout.ConsentVisualStepLayout$$Lambda$1;
import org.researchstack.backbone.ui.step.layout.ConsentVisualStepLayout$$Lambda$2;
import org.researchstack.backbone.ui.step.layout.StepLayout;
import org.researchstack.backbone.ui.views.FixedSubmitBarLayout;
import org.researchstack.backbone.ui.views.SubmitBar;
import org.researchstack.backbone.utils.ResUtils;
import org.researchstack.backbone.utils.TextUtils;

public class ConsentVisualStepLayout
extends FixedSubmitBarLayout
implements StepLayout {
    private StepCallbacks callbacks;
    private ConsentVisualStep step;

    public ConsentVisualStepLayout(Context context) {
        super(context);
    }

    public ConsentVisualStepLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ConsentVisualStepLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    public void initialize(Step step, StepResult result) {
        this.step = (ConsentVisualStep)step;
        this.initializeStep();
    }

    @Override
    public View getLayout() {
        return this;
    }

    @Override
    public boolean isBackEventConsumed() {
        this.callbacks.onSaveStep(-1, this.step, null);
        return false;
    }

    @Override
    public void setCallbacks(StepCallbacks callbacks) {
        this.callbacks = callbacks;
    }

    @Override
    public int getContentResourceId() {
        return R.layout.rsb_step_layout_consent_visual;
    }

    private void initializeStep() {
        ConsentSection data = this.step.getSection();
        TypedValue typedValue = new TypedValue();
        TypedArray a = this.getContext().obtainStyledAttributes(typedValue.data, new int[]{R.attr.colorAccent});
        int accentColor = a.getColor(0, 0);
        a.recycle();
        ImageView imageView = (ImageView)this.findViewById(R.id.image);
        String imageName = !TextUtils.isEmpty(data.getCustomImageName()) ? data.getCustomImageName() : data.getType().getImageName();
        int imageResId = ResUtils.getDrawableResourceId(this.getContext(), imageName);
        if (imageResId != 0) {
            Drawable drawable2 = this.getResources().getDrawable(imageResId);
            drawable2 = DrawableCompat.wrap((Drawable)drawable2);
            DrawableCompat.setTint((Drawable)drawable2, (int)accentColor);
            imageView.setImageDrawable(drawable2);
            imageView.setVisibility(0);
        } else {
            imageView.setVisibility(8);
        }
        TextView titleView = (TextView)this.findViewById(R.id.title);
        String title = TextUtils.isEmpty(data.getTitle()) ? this.getResources().getString(data.getType().getTitleResId()) : data.getTitle();
        titleView.setText((CharSequence)title);
        TextView summaryView = (TextView)this.findViewById(R.id.summary);
        summaryView.setText((CharSequence)data.getSummary());
        TextView moreInfoView = (TextView)this.findViewById(R.id.more_info);
        if (!TextUtils.isEmpty(data.getHtmlContent())) {
            if (!TextUtils.isEmpty(data.getCustomLearnMoreButtonTitle())) {
                moreInfoView.setText((CharSequence)data.getCustomLearnMoreButtonTitle());
            } else {
                moreInfoView.setText(data.getType().getMoreInfoResId());
            }
            RxView.clicks((View)moreInfoView).subscribe(ConsentVisualStepLayout$$Lambda$1.lambdaFactory$(this, data));
        } else {
            moreInfoView.setVisibility(8);
        }
        SubmitBar submitBar = (SubmitBar)this.findViewById(R.id.rsb_submit_bar);
        submitBar.setPositiveTitle(this.step.getNextButtonString());
        submitBar.setPositiveAction(ConsentVisualStepLayout$$Lambda$2.lambdaFactory$(this));
        submitBar.getNegativeActionView().setVisibility(8);
    }

    private /* synthetic */ void lambda$initializeStep$1(Object v) {
        this.callbacks.onSaveStep(1, this.step, null);
    }

    private /* synthetic */ void lambda$initializeStep$0(ConsentSection data, Object v) {
        String webTitle = this.getResources().getString(R.string.rsb_consent_section_more_info);
        Intent webDoc = ViewWebDocumentActivity.newIntentForContent(this.getContext(), webTitle, TextUtils.isEmpty(data.getContent()) ? data.getHtmlContent() : data.getContent());
        this.getContext().startActivity(webDoc);
    }

    static /* synthetic */ void access$lambda$0(ConsentVisualStepLayout consentVisualStepLayout, ConsentSection consentSection, Object object) {
        consentVisualStepLayout.lambda$initializeStep$0(consentSection, object);
    }

    static /* synthetic */ void access$lambda$1(ConsentVisualStepLayout consentVisualStepLayout, Object object) {
        consentVisualStepLayout.lambda$initializeStep$1(object);
    }
}

