/*
 * Decompiled with CFR 0.152.
 */
package org.researchstack.backbone.ui.step.layout;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.AttributeSet;
import android.util.Base64;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.jakewharton.rxbinding.view.RxView;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.researchstack.backbone.R;
import org.researchstack.backbone.result.StepResult;
import org.researchstack.backbone.step.ConsentSignatureStep;
import org.researchstack.backbone.step.Step;
import org.researchstack.backbone.ui.callbacks.SignatureCallbacks;
import org.researchstack.backbone.ui.callbacks.StepCallbacks;
import org.researchstack.backbone.ui.step.layout.ConsentSignatureStepLayout$$Lambda$1;
import org.researchstack.backbone.ui.step.layout.ConsentSignatureStepLayout$$Lambda$2;
import org.researchstack.backbone.ui.step.layout.StepLayout;
import org.researchstack.backbone.ui.views.SignatureView;
import org.researchstack.backbone.ui.views.SubmitBar;
import org.researchstack.backbone.utils.FormatHelper;
import org.researchstack.backbone.utils.TextUtils;

public class ConsentSignatureStepLayout
extends RelativeLayout
implements StepLayout {
    public static final String KEY_SIGNATURE = "ConsentSignatureStep.Signature";
    public static final String KEY_SIGNATURE_DATE = "ConsentSignatureStep.Signature.Date";
    private SignatureView signatureView;
    private StepCallbacks callbacks;
    private Step step;
    private StepResult<String> result;

    public ConsentSignatureStepLayout(Context context) {
        super(context);
    }

    public ConsentSignatureStepLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ConsentSignatureStepLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    public void initialize(Step step, StepResult result) {
        this.step = step;
        this.result = result == null ? new StepResult(step) : result;
        this.initializeStep();
    }

    @Override
    public View getLayout() {
        return this;
    }

    @Override
    public boolean isBackEventConsumed() {
        this.setDataToResult();
        this.callbacks.onSaveStep(-1, this.step, this.result);
        return false;
    }

    @Override
    public void setCallbacks(StepCallbacks callbacks) {
        this.callbacks = callbacks;
    }

    private void initializeStep() {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.rsb_step_layout_consent_signature, (ViewGroup)this, true);
        TextView title = (TextView)this.findViewById(R.id.title);
        title.setText((CharSequence)this.step.getTitle());
        TextView text = (TextView)this.findViewById(R.id.summary);
        text.setText((CharSequence)this.step.getText());
        final View clear = this.findViewById(R.id.layout_consent_review_signature_clear);
        this.signatureView = (SignatureView)this.findViewById(R.id.layout_consent_review_signature);
        this.signatureView.setCallbacks(new SignatureCallbacks(){

            @Override
            public void onSignatureStarted() {
                clear.setClickable(true);
                clear.animate().alpha(1.0f);
            }

            @Override
            public void onSignatureCleared() {
                clear.setClickable(false);
                clear.animate().alpha(0.0f);
            }
        });
        RxView.clicks((View)clear).subscribe(ConsentSignatureStepLayout$$Lambda$1.lambdaFactory$(this));
        clear.setClickable(this.signatureView.isSignatureDrawn());
        clear.animate().alpha(this.signatureView.isSignatureDrawn() ? 1.0f : 0.0f);
        SubmitBar submitBar = (SubmitBar)this.findViewById(R.id.submit_bar);
        submitBar.getNegativeActionView().setVisibility(8);
        submitBar.setPositiveAction(ConsentSignatureStepLayout$$Lambda$2.lambdaFactory$(this));
    }

    private void setDataToResult() {
        String format = ((ConsentSignatureStep)this.step).getSignatureDateFormat();
        DateFormat signatureDateFormat = !TextUtils.isEmpty(format) ? new SimpleDateFormat(format) : FormatHelper.getSignatureFormat();
        String formattedSignDate = signatureDateFormat.format(new Date());
        this.result.setResultForIdentifier(KEY_SIGNATURE, this.getBase64EncodedImage());
        this.result.setResultForIdentifier(KEY_SIGNATURE_DATE, formattedSignDate);
    }

    private String getBase64EncodedImage() {
        Bitmap bitmap = this.signatureView.createSignatureBitmap();
        if (bitmap != null) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)stream);
            byte[] byteArray = stream.toByteArray();
            return Base64.encodeToString((byte[])byteArray, (int)0);
        }
        return null;
    }

    private /* synthetic */ void lambda$initializeStep$1(Object v) {
        if (this.signatureView.isSignatureDrawn()) {
            this.setDataToResult();
            this.callbacks.onSaveStep(1, this.step, this.result);
        } else {
            Toast.makeText((Context)this.getContext(), (int)R.string.rsb_error_invalid_signature, (int)0).show();
        }
    }

    private /* synthetic */ void lambda$initializeStep$0(Object v) {
        this.signatureView.clearSignature();
    }

    static /* synthetic */ void access$lambda$0(ConsentSignatureStepLayout consentSignatureStepLayout, Object object) {
        consentSignatureStepLayout.lambda$initializeStep$0(object);
    }

    static /* synthetic */ void access$lambda$1(ConsentSignatureStepLayout consentSignatureStepLayout, Object object) {
        consentSignatureStepLayout.lambda$initializeStep$1(object);
    }
}

