/*
 * Decompiled with CFR 0.152.
 */
package org.researchstack.backbone.ui.step.layout;

import android.content.Context;
import android.content.DialogInterface;
import android.support.v7.app.AlertDialog;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.LinearLayout;
import org.researchstack.backbone.R;
import org.researchstack.backbone.result.StepResult;
import org.researchstack.backbone.step.ConsentDocumentStep;
import org.researchstack.backbone.step.Step;
import org.researchstack.backbone.ui.callbacks.StepCallbacks;
import org.researchstack.backbone.ui.step.layout.ConsentDocumentStepLayout$$Lambda$1;
import org.researchstack.backbone.ui.step.layout.ConsentDocumentStepLayout$$Lambda$2;
import org.researchstack.backbone.ui.step.layout.ConsentDocumentStepLayout$$Lambda$3;
import org.researchstack.backbone.ui.step.layout.ConsentDocumentStepLayout$$Lambda$4;
import org.researchstack.backbone.ui.step.layout.StepLayout;
import org.researchstack.backbone.ui.views.SubmitBar;

public class ConsentDocumentStepLayout
extends LinearLayout
implements StepLayout {
    private StepCallbacks callbacks;
    private String confirmationDialogBody;
    private String htmlContent;
    private ConsentDocumentStep step;
    private StepResult<Boolean> stepResult;

    public ConsentDocumentStepLayout(Context context) {
        super(context);
    }

    public ConsentDocumentStepLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ConsentDocumentStepLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    public void initialize(Step step, StepResult result) {
        this.step = (ConsentDocumentStep)step;
        this.confirmationDialogBody = ((ConsentDocumentStep)step).getConfirmMessage();
        this.htmlContent = ((ConsentDocumentStep)step).getConsentHTML();
        this.stepResult = result;
        if (this.stepResult == null) {
            this.stepResult = new StepResult(step);
        }
        this.initializeStep();
    }

    @Override
    public View getLayout() {
        return this;
    }

    @Override
    public boolean isBackEventConsumed() {
        this.stepResult.setResult(false);
        this.callbacks.onSaveStep(-1, this.step, this.stepResult);
        return false;
    }

    @Override
    public void setCallbacks(StepCallbacks callbacks) {
        this.callbacks = callbacks;
    }

    private void initializeStep() {
        this.setOrientation(1);
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.rsb_step_layout_consent_doc, (ViewGroup)this, true);
        WebView pdfView = (WebView)this.findViewById(R.id.webview);
        pdfView.loadData(this.htmlContent, "text/html; charset=UTF-8", null);
        SubmitBar submitBar = (SubmitBar)this.findViewById(R.id.submit_bar);
        submitBar.setPositiveAction(ConsentDocumentStepLayout$$Lambda$1.lambdaFactory$(this));
        submitBar.setNegativeAction(ConsentDocumentStepLayout$$Lambda$2.lambdaFactory$(this));
    }

    private void showDialog() {
        new AlertDialog.Builder(this.getContext()).setTitle(R.string.rsb_consent_review_alert_title).setMessage((CharSequence)this.confirmationDialogBody).setCancelable(false).setPositiveButton(R.string.rsb_agree, ConsentDocumentStepLayout$$Lambda$3.lambdaFactory$(this)).setNegativeButton(R.string.rsb_consent_review_cancel, ConsentDocumentStepLayout$$Lambda$4.lambdaFactory$()).show();
    }

    private static /* synthetic */ void lambda$showDialog$3(DialogInterface dialog, int which) {
    }

    private /* synthetic */ void lambda$showDialog$2(DialogInterface dialog, int which) {
        this.stepResult.setResult(true);
        this.callbacks.onSaveStep(1, this.step, this.stepResult);
    }

    private /* synthetic */ void lambda$initializeStep$1(Object v) {
        this.callbacks.onCancelStep();
    }

    private /* synthetic */ void lambda$initializeStep$0(Object v) {
        this.showDialog();
    }

    static /* synthetic */ void access$lambda$0(ConsentDocumentStepLayout consentDocumentStepLayout, Object object) {
        consentDocumentStepLayout.lambda$initializeStep$0(object);
    }

    static /* synthetic */ void access$lambda$1(ConsentDocumentStepLayout consentDocumentStepLayout, Object object) {
        consentDocumentStepLayout.lambda$initializeStep$1(object);
    }

    static /* synthetic */ void access$lambda$2(ConsentDocumentStepLayout consentDocumentStepLayout, DialogInterface dialogInterface, int n) {
        consentDocumentStepLayout.lambda$showDialog$2(dialogInterface, n);
    }

    static /* synthetic */ void access$lambda$3(DialogInterface dialogInterface, int n) {
        ConsentDocumentStepLayout.lambda$showDialog$3(dialogInterface, n);
    }
}

