/*
 * Decompiled with CFR 0.152.
 */
package org.researchstack.backbone.ui.step.body;

import android.content.res.Resources;
import android.text.InputFilter;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.jakewharton.rxbinding.widget.RxTextView;
import org.researchstack.backbone.R;
import org.researchstack.backbone.answerformat.TextAnswerFormat;
import org.researchstack.backbone.result.StepResult;
import org.researchstack.backbone.step.QuestionStep;
import org.researchstack.backbone.step.Step;
import org.researchstack.backbone.ui.step.body.BodyAnswer;
import org.researchstack.backbone.ui.step.body.StepBody;
import org.researchstack.backbone.ui.step.body.TextQuestionBody$$Lambda$1;
import org.researchstack.backbone.utils.TextUtils;
import org.researchstack.backbone.utils.ViewUtils;

public class TextQuestionBody
implements StepBody {
    private QuestionStep step;
    private StepResult<String> result;
    private EditText editText;

    public TextQuestionBody(Step step, StepResult result) {
        this.step = (QuestionStep)step;
        this.result = result == null ? new StepResult(step) : result;
    }

    @Override
    public View getBodyView(int viewType, LayoutInflater inflater, ViewGroup parent) {
        View body = inflater.inflate(R.layout.rsb_item_edit_text_compact, parent, false);
        this.editText = (EditText)body.findViewById(R.id.value);
        if (this.step.getPlaceholder() != null) {
            this.editText.setHint((CharSequence)this.step.getPlaceholder());
        } else {
            this.editText.setHint(R.string.rsb_hint_step_body_text);
        }
        TextView title = (TextView)body.findViewById(R.id.label);
        if (viewType == 1) {
            title.setText((CharSequence)this.step.getTitle());
        } else {
            title.setVisibility(8);
        }
        String stringResult = this.result.getResult();
        if (!TextUtils.isEmpty(stringResult)) {
            this.editText.setText((CharSequence)stringResult);
        }
        RxTextView.textChanges((TextView)this.editText).subscribe(TextQuestionBody$$Lambda$1.lambdaFactory$(this));
        TextAnswerFormat format = (TextAnswerFormat)this.step.getAnswerFormat();
        this.editText.setSingleLine(!format.isMultipleLines());
        if (format.getMaximumLength() > 0) {
            InputFilter.LengthFilter maxLengthFilter = new InputFilter.LengthFilter(format.getMaximumLength());
            InputFilter[] filters = ViewUtils.addFilter(this.editText.getFilters(), (InputFilter)maxLengthFilter);
            this.editText.setFilters(filters);
        }
        Resources res = parent.getResources();
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2);
        layoutParams.leftMargin = res.getDimensionPixelSize(R.dimen.rsb_margin_left);
        layoutParams.rightMargin = res.getDimensionPixelSize(R.dimen.rsb_margin_right);
        body.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        return body;
    }

    @Override
    public StepResult getStepResult(boolean skipped) {
        if (skipped) {
            this.result.setResult(null);
        }
        return this.result;
    }

    @Override
    public BodyAnswer getBodyAnswerState() {
        TextAnswerFormat format = (TextAnswerFormat)this.step.getAnswerFormat();
        if (!format.isAnswerValid(this.editText.getText().toString())) {
            return BodyAnswer.INVALID;
        }
        return BodyAnswer.VALID;
    }

    private /* synthetic */ void lambda$getBodyView$0(CharSequence text) {
        this.result.setResult(text.toString());
    }

    static /* synthetic */ void access$lambda$0(TextQuestionBody textQuestionBody, CharSequence charSequence) {
        textQuestionBody.lambda$getBodyView$0(charSequence);
    }
}

