/*
 * Decompiled with CFR 0.152.
 */
package org.researchstack.backbone.ui.step.body;

import android.content.Context;
import android.content.res.Resources;
import android.support.v4.content.ContextCompat;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.TextView;
import org.researchstack.backbone.R;
import org.researchstack.backbone.answerformat.ChoiceAnswerFormat;
import org.researchstack.backbone.model.Choice;
import org.researchstack.backbone.result.StepResult;
import org.researchstack.backbone.step.QuestionStep;
import org.researchstack.backbone.step.Step;
import org.researchstack.backbone.ui.step.body.BodyAnswer;
import org.researchstack.backbone.ui.step.body.SingleChoiceQuestionBody$$Lambda$1;
import org.researchstack.backbone.ui.step.body.StepBody;

public class SingleChoiceQuestionBody<T>
implements StepBody {
    private QuestionStep step;
    private StepResult<T> result;
    private ChoiceAnswerFormat format;
    private Choice<T>[] choices;
    private T currentSelected;

    public SingleChoiceQuestionBody(Step step, StepResult result) {
        this.step = (QuestionStep)step;
        this.result = result == null ? new StepResult(step) : result;
        this.format = (ChoiceAnswerFormat)this.step.getAnswerFormat();
        this.choices = this.format.getChoices();
        T resultValue = this.result.getResult();
        if (resultValue != null) {
            for (Choice<T> choice : this.choices) {
                if (!choice.getValue().equals(resultValue)) continue;
                this.currentSelected = choice.getValue();
            }
        }
    }

    @Override
    public View getBodyView(int viewType, LayoutInflater inflater, ViewGroup parent) {
        View view = this.getViewForType(viewType, inflater, parent);
        Resources res = parent.getResources();
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2);
        layoutParams.leftMargin = res.getDimensionPixelSize(R.dimen.rsb_margin_left);
        layoutParams.rightMargin = res.getDimensionPixelSize(R.dimen.rsb_margin_right);
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        return view;
    }

    private View getViewForType(int viewType, LayoutInflater inflater, ViewGroup parent) {
        if (viewType == 0) {
            return this.initViewDefault(inflater, parent);
        }
        if (viewType == 1) {
            return this.initViewCompact(inflater, parent);
        }
        throw new IllegalArgumentException("Invalid View Type");
    }

    private View initViewDefault(LayoutInflater inflater, ViewGroup parent) {
        RadioGroup radioGroup = new RadioGroup(parent.getContext());
        radioGroup.setShowDividers(2);
        radioGroup.setDividerDrawable(ContextCompat.getDrawable((Context)parent.getContext(), (int)R.drawable.rsb_divider_empty_8dp));
        for (int i = 0; i < this.choices.length; ++i) {
            Choice<T> choice = this.choices[i];
            RadioButton radioButton = (RadioButton)inflater.inflate(R.layout.rsb_item_radio, (ViewGroup)radioGroup, false);
            radioButton.setText((CharSequence)choice.getText());
            radioButton.setId(i);
            if (this.currentSelected != null) {
                radioButton.setChecked(this.currentSelected.equals(choice.getValue()));
            }
            radioGroup.addView((View)radioButton);
        }
        radioGroup.setOnCheckedChangeListener(SingleChoiceQuestionBody$$Lambda$1.lambdaFactory$(this));
        return radioGroup;
    }

    private View initViewCompact(LayoutInflater inflater, ViewGroup parent) {
        ViewGroup compactView = (ViewGroup)this.initViewDefault(inflater, parent);
        TextView label = (TextView)inflater.inflate(R.layout.rsb_item_text_view_title_compact, compactView, false);
        label.setText((CharSequence)this.step.getTitle());
        compactView.addView((View)label, 0);
        return compactView;
    }

    @Override
    public StepResult getStepResult(boolean skipped) {
        if (skipped) {
            this.result.setResult(null);
        } else {
            this.result.setResult(this.currentSelected);
        }
        return this.result;
    }

    @Override
    public BodyAnswer getBodyAnswerState() {
        if (this.currentSelected == null) {
            return new BodyAnswer(false, R.string.rsb_invalid_answer_choice, new String[0]);
        }
        return BodyAnswer.VALID;
    }

    private /* synthetic */ void lambda$initViewDefault$0(RadioGroup group, int checkedId) {
        Choice<T> choice = this.choices[checkedId];
        this.currentSelected = choice.getValue();
    }

    static /* synthetic */ void access$lambda$0(SingleChoiceQuestionBody singleChoiceQuestionBody, RadioGroup radioGroup, int n) {
        singleChoiceQuestionBody.lambda$initViewDefault$0(radioGroup, n);
    }
}

