/*
 * Decompiled with CFR 0.152.
 */
package org.researchstack.backbone.ui.step.body;

import android.content.Context;
import android.content.res.Resources;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.AppCompatCheckBox;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CompoundButton;
import android.widget.LinearLayout;
import android.widget.RadioGroup;
import android.widget.TextView;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.researchstack.backbone.R;
import org.researchstack.backbone.answerformat.ChoiceAnswerFormat;
import org.researchstack.backbone.model.Choice;
import org.researchstack.backbone.result.StepResult;
import org.researchstack.backbone.step.QuestionStep;
import org.researchstack.backbone.step.Step;
import org.researchstack.backbone.ui.step.body.BodyAnswer;
import org.researchstack.backbone.ui.step.body.MultiChoiceQuestionBody$$Lambda$1;
import org.researchstack.backbone.ui.step.body.StepBody;

public class MultiChoiceQuestionBody<T>
implements StepBody {
    private QuestionStep step;
    private StepResult<T[]> result;
    private ChoiceAnswerFormat format;
    private Choice<T>[] choices;
    private Set<T> currentSelected;

    public MultiChoiceQuestionBody(Step step, StepResult result) {
        this.step = (QuestionStep)step;
        this.result = result == null ? new StepResult(step) : result;
        this.format = (ChoiceAnswerFormat)this.step.getAnswerFormat();
        this.choices = this.format.getChoices();
        this.currentSelected = new HashSet<T>();
        T[] resultArray = this.result.getResult();
        if (resultArray != null && resultArray.length > 0) {
            this.currentSelected.addAll(Arrays.asList(resultArray));
        }
    }

    @Override
    public View getBodyView(int viewType, LayoutInflater inflater, ViewGroup parent) {
        View view = this.getViewForType(viewType, inflater, parent);
        Resources res = parent.getResources();
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2);
        layoutParams.leftMargin = res.getDimensionPixelSize(R.dimen.rsb_margin_left);
        layoutParams.rightMargin = res.getDimensionPixelSize(R.dimen.rsb_margin_right);
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        return view;
    }

    private View getViewForType(int viewType, LayoutInflater inflater, ViewGroup parent) {
        if (viewType == 0) {
            return this.initViewDefault(inflater, parent);
        }
        if (viewType == 1) {
            return this.initViewCompact(inflater, parent);
        }
        throw new IllegalArgumentException("Invalid View Type");
    }

    private View initViewDefault(LayoutInflater inflater, ViewGroup parent) {
        RadioGroup radioGroup = new RadioGroup(inflater.getContext());
        radioGroup.setShowDividers(2);
        radioGroup.setDividerDrawable(ContextCompat.getDrawable((Context)parent.getContext(), (int)R.drawable.rsb_divider_empty_8dp));
        for (int i = 0; i < this.choices.length; ++i) {
            Choice<T> item = this.choices[i];
            AppCompatCheckBox checkBox = (AppCompatCheckBox)inflater.inflate(R.layout.rsb_item_checkbox, (ViewGroup)radioGroup, false);
            checkBox.setText((CharSequence)item.getText());
            checkBox.setId(i);
            radioGroup.addView((View)checkBox);
            if (this.currentSelected.contains(item.getValue())) {
                checkBox.setChecked(true);
            }
            checkBox.setOnCheckedChangeListener(MultiChoiceQuestionBody$$Lambda$1.lambdaFactory$(this, item));
        }
        return radioGroup;
    }

    private View initViewCompact(LayoutInflater inflater, ViewGroup parent) {
        ViewGroup compactView = (ViewGroup)this.initViewDefault(inflater, parent);
        TextView label = (TextView)inflater.inflate(R.layout.rsb_item_text_view_title_compact, compactView, false);
        label.setText((CharSequence)this.step.getTitle());
        compactView.addView((View)label, 0);
        return compactView;
    }

    @Override
    public StepResult getStepResult(boolean skipped) {
        if (skipped) {
            this.currentSelected.clear();
            this.result.setResult(this.currentSelected.toArray());
        } else {
            this.result.setResult(this.currentSelected.toArray());
        }
        return this.result;
    }

    @Override
    public BodyAnswer getBodyAnswerState() {
        if (this.currentSelected.isEmpty()) {
            return new BodyAnswer(false, R.string.rsb_invalid_answer_choice, new String[0]);
        }
        return BodyAnswer.VALID;
    }

    private /* synthetic */ void lambda$initViewDefault$0(Choice item, CompoundButton buttonView, boolean isChecked) {
        if (isChecked) {
            this.currentSelected.add(item.getValue());
        } else {
            this.currentSelected.remove(item.getValue());
        }
    }

    static /* synthetic */ void access$lambda$0(MultiChoiceQuestionBody multiChoiceQuestionBody, Choice choice, CompoundButton compoundButton, boolean bl) {
        multiChoiceQuestionBody.lambda$initViewDefault$0(choice, compoundButton, bl);
    }
}

