/*
 * Decompiled with CFR 0.152.
 */
package org.researchstack.backbone.ui.step.body;

import android.support.annotation.NonNull;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.researchstack.backbone.R;
import org.researchstack.backbone.result.StepResult;
import org.researchstack.backbone.step.FormStep;
import org.researchstack.backbone.step.QuestionStep;
import org.researchstack.backbone.step.Step;
import org.researchstack.backbone.ui.step.body.BodyAnswer;
import org.researchstack.backbone.ui.step.body.StepBody;
import org.researchstack.backbone.utils.LogExt;

public class FormBody
implements StepBody {
    private FormStep step;
    private StepResult<StepResult> result;
    private List<StepBody> formStepChildren;

    public FormBody(Step step, StepResult result) {
        this.step = (FormStep)step;
        this.result = result == null ? new StepResult(step) : result;
    }

    @Override
    public View getBodyView(int viewType, LayoutInflater inflater, ViewGroup parent) {
        LinearLayout body = (LinearLayout)inflater.inflate(R.layout.rsb_step_layout_form_body, parent, false);
        List<QuestionStep> questionSteps = this.step.getFormSteps();
        this.formStepChildren = new ArrayList<StepBody>(questionSteps.size());
        for (QuestionStep questionStep : questionSteps) {
            StepBody stepBody = this.createStepBody(questionStep);
            View bodyView = stepBody.getBodyView(1, inflater, (ViewGroup)body);
            body.addView(bodyView);
            this.formStepChildren.add(stepBody);
        }
        return body;
    }

    @Override
    public StepResult getStepResult(boolean skipped) {
        for (StepBody child : this.formStepChildren) {
            StepResult childResult = child.getStepResult(skipped);
            if (childResult == null) continue;
            this.result.setResultForIdentifier(childResult.getIdentifier(), childResult);
        }
        return this.result;
    }

    @Override
    public BodyAnswer getBodyAnswerState() {
        for (StepBody formStepBody : this.formStepChildren) {
            BodyAnswer bodyAnswer = formStepBody.getBodyAnswerState();
            if (bodyAnswer.isValid()) continue;
            return bodyAnswer;
        }
        return BodyAnswer.VALID;
    }

    @NonNull
    private StepBody createStepBody(QuestionStep questionStep) {
        StepResult childResult = this.result.getResultForIdentifier(questionStep.getIdentifier());
        Class<?> cls = questionStep.getStepBodyClass();
        try {
            Constructor<?> constructor = cls.getConstructor(Step.class, StepResult.class);
            return (StepBody)constructor.newInstance(questionStep, childResult);
        }
        catch (Exception e) {
            LogExt.e(this.getClass(), "Cannot instantiate step body for step " + questionStep.getStepTitle() + ", class name: " + cls.getCanonicalName());
            throw new RuntimeException(e);
        }
    }
}

