/*
 * Decompiled with CFR 0.152.
 */
package org.researchstack.backbone.ui.step.body;

import android.content.res.Resources;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.LinearLayout;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import org.researchstack.backbone.R;
import org.researchstack.backbone.answerformat.DurationAnswerFormat;
import org.researchstack.backbone.result.StepResult;
import org.researchstack.backbone.step.QuestionStep;
import org.researchstack.backbone.step.Step;
import org.researchstack.backbone.ui.step.body.BodyAnswer;
import org.researchstack.backbone.ui.step.body.StepBody;

public class DurationQuestionBody
implements StepBody {
    private QuestionStep step;
    private StepResult<Integer> result;
    private DurationAnswerFormat format;
    private int viewType;
    private Spinner hoursSpinner;
    private Spinner minutesSpinner;

    public DurationQuestionBody(Step step, StepResult result) {
        this.step = (QuestionStep)step;
        this.result = result == null ? new StepResult(step) : result;
        this.format = (DurationAnswerFormat)this.step.getAnswerFormat();
    }

    @Override
    public View getBodyView(int viewType, LayoutInflater inflater, ViewGroup parent) {
        this.viewType = viewType;
        View view = this.getViewForType(viewType, inflater, parent);
        Resources res = parent.getResources();
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2);
        layoutParams.leftMargin = res.getDimensionPixelSize(R.dimen.rsb_margin_left);
        layoutParams.rightMargin = res.getDimensionPixelSize(R.dimen.rsb_margin_right);
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        return view;
    }

    private View getViewForType(int viewType, LayoutInflater inflater, ViewGroup parent) {
        if (viewType == 0 || viewType == 1) {
            return this.initView(inflater, parent);
        }
        throw new IllegalArgumentException("Invalid View Type");
    }

    private View initView(LayoutInflater inflater, ViewGroup parent) {
        View v = inflater.inflate(R.layout.rsb_item_edit_duration, parent, false);
        Object[] hoursStrs = new String[24];
        for (int i = 0; i < 24; ++i) {
            hoursStrs[i] = String.valueOf(i);
        }
        ArrayAdapter hoursChoices = new ArrayAdapter(inflater.getContext(), 17367048, hoursStrs);
        hoursChoices.setDropDownViewResource(0x1090009);
        this.hoursSpinner = (Spinner)v.findViewById(R.id.hours);
        this.hoursSpinner.setAdapter((SpinnerAdapter)hoursChoices);
        Object[] minutesStrs = new String[60];
        for (int i = 0; i < 60; ++i) {
            minutesStrs[i] = String.valueOf(i);
        }
        ArrayAdapter minutesChoices = new ArrayAdapter(inflater.getContext(), 17367048, minutesStrs);
        minutesChoices.setDropDownViewResource(0x1090009);
        this.minutesSpinner = (Spinner)v.findViewById(R.id.minutes);
        this.minutesSpinner.setAdapter((SpinnerAdapter)minutesChoices);
        return v;
    }

    @Override
    public StepResult getStepResult(boolean skipped) {
        if (skipped) {
            this.result.setResult(null);
        } else {
            int hours = this.hoursSpinner.getSelectedItemPosition();
            int minutes = this.minutesSpinner.getSelectedItemPosition();
            this.result.setResult(hours * 60 + minutes);
        }
        return this.result;
    }

    @Override
    public BodyAnswer getBodyAnswerState() {
        return BodyAnswer.VALID;
    }
}

