/*
 * Decompiled with CFR 0.152.
 */
package org.researchstack.backbone.ui.step.body;

import android.content.Context;
import android.content.res.Resources;
import android.text.InputFilter;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import org.researchstack.backbone.R;
import org.researchstack.backbone.answerformat.DecimalAnswerFormat;
import org.researchstack.backbone.result.StepResult;
import org.researchstack.backbone.step.QuestionStep;
import org.researchstack.backbone.step.Step;
import org.researchstack.backbone.ui.step.body.BodyAnswer;
import org.researchstack.backbone.ui.step.body.StepBody;
import org.researchstack.backbone.utils.TextUtils;
import org.researchstack.backbone.utils.ViewUtils;

public class DecimalQuestionBody
implements StepBody {
    private QuestionStep step;
    private StepResult<Float> result;
    private DecimalAnswerFormat format;
    private int viewType;
    private EditText editText;

    public DecimalQuestionBody(Step step, StepResult result) {
        this.step = (QuestionStep)step;
        this.result = result == null ? new StepResult(step) : result;
        this.format = (DecimalAnswerFormat)this.step.getAnswerFormat();
    }

    @Override
    public View getBodyView(int viewType, LayoutInflater inflater, ViewGroup parent) {
        this.viewType = viewType;
        View view = this.getViewForType(viewType, inflater, parent);
        Resources res = parent.getResources();
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2);
        layoutParams.leftMargin = res.getDimensionPixelSize(R.dimen.rsb_margin_left);
        layoutParams.rightMargin = res.getDimensionPixelSize(R.dimen.rsb_margin_right);
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        return view;
    }

    private View getViewForType(int viewType, LayoutInflater inflater, ViewGroup parent) {
        if (viewType == 0) {
            return this.initViewDefault(inflater, parent);
        }
        if (viewType == 1) {
            return this.initViewCompact(inflater, parent);
        }
        throw new IllegalArgumentException("Invalid View Type");
    }

    private View initViewDefault(LayoutInflater inflater, ViewGroup parent) {
        this.editText = (EditText)inflater.inflate(R.layout.rsb_item_edit_text, parent, false);
        this.setFilters(parent.getContext());
        return this.editText;
    }

    private View initViewCompact(LayoutInflater inflater, ViewGroup parent) {
        View formItemView = inflater.inflate(R.layout.rsb_item_edit_text_compact, parent, false);
        TextView title = (TextView)formItemView.findViewById(R.id.label);
        title.setText((CharSequence)this.step.getTitle());
        this.editText = (EditText)formItemView.findViewById(R.id.value);
        this.setFilters(parent.getContext());
        return formItemView;
    }

    private void setFilters(Context context) {
        float maxValue;
        this.editText.setSingleLine(true);
        float minValue = this.format.getMinValue();
        float f = maxValue = this.format.getMaxValue() == 0.0f ? Float.MAX_VALUE : this.format.getMaxValue();
        if (this.step.getPlaceholder() != null) {
            this.editText.setHint((CharSequence)this.step.getPlaceholder());
        } else if (maxValue == 2.1474836E9f) {
            this.editText.setHint((CharSequence)context.getString(R.string.rsb_hint_step_body_int_no_max));
        } else {
            this.editText.setHint((CharSequence)context.getString(R.string.rsb_hint_step_body_dec, new Object[]{Float.valueOf(minValue), Float.valueOf(maxValue)}));
        }
        this.editText.setInputType(8194);
        if (this.result.getResult() != null) {
            this.editText.setText((CharSequence)String.valueOf(this.result.getResult()));
        }
        String minStr = Float.toString(minValue);
        String maxStr = Float.toString(maxValue);
        int maxLength = maxStr.length() >= minStr.length() ? maxStr.length() : minStr.length();
        InputFilter.LengthFilter maxLengthFilter = new InputFilter.LengthFilter(maxLength);
        InputFilter[] newFilters = ViewUtils.addFilter(this.editText.getFilters(), (InputFilter)maxLengthFilter);
        this.editText.setFilters(newFilters);
    }

    @Override
    public StepResult getStepResult(boolean skipped) {
        if (skipped) {
            this.result.setResult(null);
        } else {
            String numString = this.editText.getText().toString();
            if (!TextUtils.isEmpty(numString)) {
                this.result.setResult(Float.valueOf(this.editText.getText().toString()));
            }
        }
        return this.result;
    }

    @Override
    public BodyAnswer getBodyAnswerState() {
        if (this.editText == null) {
            return BodyAnswer.INVALID;
        }
        return this.format.validateAnswer(this.editText.getText().toString());
    }
}

