/*
 * Decompiled with CFR 0.152.
 */
package org.researchstack.backbone.ui.step.body;

import android.app.DatePickerDialog;
import android.app.TimePickerDialog;
import android.content.Context;
import android.content.res.Resources;
import android.support.v7.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.DatePicker;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.TimePicker;
import java.text.DateFormat;
import java.util.Calendar;
import org.researchstack.backbone.R;
import org.researchstack.backbone.answerformat.AnswerFormat;
import org.researchstack.backbone.answerformat.DateAnswerFormat;
import org.researchstack.backbone.result.StepResult;
import org.researchstack.backbone.step.QuestionStep;
import org.researchstack.backbone.step.Step;
import org.researchstack.backbone.ui.step.body.BodyAnswer;
import org.researchstack.backbone.ui.step.body.DateQuestionBody$$Lambda$1;
import org.researchstack.backbone.ui.step.body.DateQuestionBody$$Lambda$2;
import org.researchstack.backbone.ui.step.body.DateQuestionBody$$Lambda$3;
import org.researchstack.backbone.ui.step.body.DateQuestionBody$$Lambda$4;
import org.researchstack.backbone.ui.step.body.DateQuestionBody$$Lambda$5;
import org.researchstack.backbone.ui.step.body.DateQuestionBody$$Lambda$6;
import org.researchstack.backbone.ui.step.body.StepBody;
import org.researchstack.backbone.utils.FormatHelper;

public class DateQuestionBody
implements StepBody {
    private QuestionStep step;
    private StepResult<Long> result;
    private DateAnswerFormat format;
    private Calendar calendar;
    private DateFormat dateformatter;
    private boolean hasChosenDate;

    public DateQuestionBody(Step step, StepResult result) {
        this.step = (QuestionStep)step;
        this.result = result == null ? new StepResult(step) : result;
        this.format = (DateAnswerFormat)this.step.getAnswerFormat();
        this.calendar = Calendar.getInstance();
        if (this.format.getStyle() == AnswerFormat.DateAnswerStyle.DateAndTime) {
            this.dateformatter = FormatHelper.getFormat(2, 2);
        } else if (this.format.getStyle() == AnswerFormat.DateAnswerStyle.Date) {
            this.dateformatter = FormatHelper.getFormat(2, -1);
        } else if (this.format.getStyle() == AnswerFormat.DateAnswerStyle.TimeOfDay) {
            this.dateformatter = FormatHelper.getFormat(-1, 2);
        }
        Long savedTimeInMillis = this.result.getResult();
        if (savedTimeInMillis != null) {
            this.calendar.setTimeInMillis(savedTimeInMillis);
            this.hasChosenDate = true;
        } else if (this.format.getDefaultDate() != null) {
            this.calendar.setTime(this.format.getDefaultDate());
            this.hasChosenDate = true;
        } else {
            this.hasChosenDate = false;
        }
    }

    @Override
    public View getBodyView(int viewType, LayoutInflater inflater, ViewGroup parent) {
        View view = inflater.inflate(R.layout.rsb_item_date_view, parent, false);
        TextView title = (TextView)view.findViewById(R.id.label);
        if (viewType == 1) {
            title.setText((CharSequence)this.step.getTitle());
        } else {
            title.setVisibility(8);
        }
        TextView textView = (TextView)view.findViewById(R.id.value);
        textView.setSingleLine(true);
        if (this.step.getPlaceholder() != null) {
            textView.setHint((CharSequence)this.step.getPlaceholder());
        } else if (this.format.getStyle() == AnswerFormat.DateAnswerStyle.Date) {
            textView.setHint(R.string.rsb_hint_step_body_date);
        } else if (this.format.getStyle() == AnswerFormat.DateAnswerStyle.TimeOfDay) {
            textView.setHint(R.string.rsb_hint_step_body_time);
        } else if (this.format.getStyle() == AnswerFormat.DateAnswerStyle.DateAndTime) {
            textView.setHint(R.string.rsb_hint_step_body_datetime);
        }
        if (this.result.getResult() != null) {
            textView.setText((CharSequence)this.createFormattedResult());
        }
        textView.setOnFocusChangeListener(DateQuestionBody$$Lambda$1.lambdaFactory$(this, textView));
        textView.setOnClickListener(DateQuestionBody$$Lambda$2.lambdaFactory$(this, textView));
        Resources res = parent.getResources();
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2);
        layoutParams.leftMargin = res.getDimensionPixelSize(R.dimen.rsb_margin_left);
        layoutParams.rightMargin = res.getDimensionPixelSize(R.dimen.rsb_margin_right);
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        return view;
    }

    @Override
    public StepResult getStepResult(boolean skipped) {
        if (skipped) {
            this.result.setResult(null);
        } else {
            this.result.setResult(this.calendar.getTimeInMillis());
        }
        return this.result;
    }

    @Override
    public BodyAnswer getBodyAnswerState() {
        if (!this.hasChosenDate) {
            return new BodyAnswer(false, R.string.rsb_invalid_answer_date_none, new String[0]);
        }
        return this.format.validateAnswer(this.calendar.getTime());
    }

    private void showDialog(TextView tv) {
        ContextThemeWrapper contextWrapper = new ContextThemeWrapper(tv.getContext(), R.style.Theme_Backbone);
        if (this.format.getStyle() == AnswerFormat.DateAnswerStyle.Date) {
            new DatePickerDialog((Context)contextWrapper, DateQuestionBody$$Lambda$3.lambdaFactory$(this, tv), this.calendar.get(1), this.calendar.get(2), this.calendar.get(5)).show();
        } else if (this.format.getStyle() == AnswerFormat.DateAnswerStyle.TimeOfDay) {
            new TimePickerDialog((Context)contextWrapper, DateQuestionBody$$Lambda$4.lambdaFactory$(this, tv), this.calendar.get(11), this.calendar.get(12), true).show();
        } else if (this.format.getStyle() == AnswerFormat.DateAnswerStyle.DateAndTime) {
            new DatePickerDialog((Context)contextWrapper, DateQuestionBody$$Lambda$5.lambdaFactory$(this, contextWrapper, tv), this.calendar.get(1), this.calendar.get(2), this.calendar.get(5)).show();
        } else {
            throw new RuntimeException("DateAnswerStyle " + (Object)((Object)this.format.getStyle()) + " is not recognised");
        }
    }

    private String createFormattedResult() {
        return this.dateformatter.format(this.calendar.getTime());
    }

    private /* synthetic */ void lambda$showDialog$5(ContextThemeWrapper contextWrapper, TextView tv, DatePicker dview, int year, int monthOfYear, int dayOfMonth) {
        this.calendar.set(year, monthOfYear, dayOfMonth);
        new TimePickerDialog((Context)contextWrapper, DateQuestionBody$$Lambda$6.lambdaFactory$(this, tv), this.calendar.get(11), this.calendar.get(12), true).show();
    }

    private /* synthetic */ void lambda$null$4(TextView tv, TimePicker tview, int hourOfDay, int minute) {
        this.calendar.set(11, hourOfDay);
        this.calendar.set(12, minute);
        this.hasChosenDate = true;
        String formattedResult = this.createFormattedResult();
        tv.setText((CharSequence)formattedResult);
    }

    private /* synthetic */ void lambda$showDialog$3(TextView tv, TimePicker view, int hourOfDay, int minute) {
        this.calendar.set(11, hourOfDay);
        this.calendar.set(12, minute);
        this.hasChosenDate = true;
        String formattedResult = this.createFormattedResult();
        tv.setText((CharSequence)formattedResult);
    }

    private /* synthetic */ void lambda$showDialog$2(TextView tv, DatePicker view, int year, int monthOfYear, int dayOfMonth) {
        this.calendar.set(year, monthOfYear, dayOfMonth);
        this.hasChosenDate = true;
        String formattedResult = this.createFormattedResult();
        tv.setText((CharSequence)formattedResult);
    }

    private /* synthetic */ void lambda$getBodyView$1(TextView textView, View v) {
        if (v.isFocused()) {
            this.showDialog(textView);
        }
    }

    private /* synthetic */ void lambda$getBodyView$0(TextView textView, View v, boolean hasFocus) {
        if (hasFocus) {
            this.showDialog(textView);
        }
    }

    static /* synthetic */ void access$lambda$0(DateQuestionBody dateQuestionBody, TextView textView, View view, boolean bl) {
        dateQuestionBody.lambda$getBodyView$0(textView, view, bl);
    }

    static /* synthetic */ void access$lambda$1(DateQuestionBody dateQuestionBody, TextView textView, View view) {
        dateQuestionBody.lambda$getBodyView$1(textView, view);
    }

    static /* synthetic */ void access$lambda$2(DateQuestionBody dateQuestionBody, TextView textView, DatePicker datePicker, int n, int n2, int n3) {
        dateQuestionBody.lambda$showDialog$2(textView, datePicker, n, n2, n3);
    }

    static /* synthetic */ void access$lambda$3(DateQuestionBody dateQuestionBody, TextView textView, TimePicker timePicker, int n, int n2) {
        dateQuestionBody.lambda$showDialog$3(textView, timePicker, n, n2);
    }

    static /* synthetic */ void access$lambda$4(DateQuestionBody dateQuestionBody, ContextThemeWrapper contextThemeWrapper, TextView textView, DatePicker datePicker, int n, int n2, int n3) {
        dateQuestionBody.lambda$showDialog$5(contextThemeWrapper, textView, datePicker, n, n2, n3);
    }

    static /* synthetic */ void access$lambda$5(DateQuestionBody dateQuestionBody, TextView textView, TimePicker timePicker, int n, int n2) {
        dateQuestionBody.lambda$null$4(textView, timePicker, n, n2);
    }
}

