/*
 * Decompiled with CFR 0.152.
 */
package org.researchstack.backbone.ui.graph;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.support.annotation.StringRes;
import android.support.design.widget.TabLayout;
import android.support.v7.widget.CardView;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.github.mikephil.charting.charts.PieChart;
import com.github.mikephil.charting.data.ChartData;
import com.github.mikephil.charting.data.PieData;
import com.jakewharton.rxbinding.view.RxView;
import java.text.NumberFormat;
import java.util.List;
import org.researchstack.backbone.R;
import org.researchstack.backbone.ui.graph.ProgressChartCard$$Lambda$1;
import org.researchstack.backbone.ui.views.IconTabLayout;
import rx.Subscription;
import rx.functions.Action1;

public class ProgressChartCard
extends CardView {
    private PieChart chart;
    private TabLayout tabLayout;
    private TextView titleTextView;
    private TextView finishView;
    private Subscription finishSub;
    private String titleText;
    private int titleTextColor;
    private float titleTextSize;
    private String titleTextTypeface;
    private String finishText;
    private int finishTextColor;
    private String centerTextFormat;
    private int centerTextColor;
    private float centerTextSize;
    private String centerTextTypeface;
    private int tabIndicatorColor;
    private int tabTextColor;
    private int tabSelectedTextColor;
    private NumberFormat numberFormat;

    public ProgressChartCard(Context context) {
        super(context);
        this.initializeRoot(null, R.attr.progressChartCardStyle);
        this.initializeViews();
    }

    public ProgressChartCard(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initializeRoot(attrs, R.attr.progressChartCardStyle);
        this.initializeViews();
    }

    public ProgressChartCard(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initializeRoot(attrs, defStyleAttr);
        this.initializeViews();
    }

    private void initializeRoot(AttributeSet attrs, int defStyleAttr) {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.rsb_view_chart_progress, (ViewGroup)this, true);
        this.numberFormat = NumberFormat.getInstance();
        this.numberFormat.setMinimumFractionDigits(0);
        this.numberFormat.setMaximumFractionDigits(2);
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.ProgressChartCard, defStyleAttr, R.style.Widget_Backbone_Chart_Progress);
        this.titleText = a.getString(R.styleable.ProgressChartCard_titleText);
        this.titleTextColor = a.getColor(R.styleable.ProgressChartCard_titleTextColor, 0);
        this.titleTextSize = a.getDimension(R.styleable.ProgressChartCard_titleTextSize, 0.0f);
        this.titleTextTypeface = a.getString(R.styleable.ProgressChartCard_titleTextTypeface);
        this.finishText = a.getString(R.styleable.ProgressChartCard_finishText);
        this.finishTextColor = a.getColor(R.styleable.ProgressChartCard_finishTextColor, 0);
        this.tabIndicatorColor = a.getColor(R.styleable.ProgressChartCard_tabIndicatorColor, 0);
        this.tabTextColor = a.getColor(R.styleable.ProgressChartCard_tabTextColor, 0);
        this.tabSelectedTextColor = a.getColor(R.styleable.ProgressChartCard_tabSelectedTextColor, 0);
        this.centerTextFormat = a.getString(R.styleable.ProgressChartCard_centerTextFormat);
        this.centerTextColor = a.getColor(R.styleable.ProgressChartCard_centerTextColor, 0);
        this.centerTextSize = a.getDimension(R.styleable.ProgressChartCard_centerTextSize, 0.0f) / this.getResources().getDisplayMetrics().density;
        this.centerTextTypeface = a.getString(R.styleable.ProgressChartCard_centerTextTypeface);
        a.recycle();
    }

    private void initializeViews() {
        this.titleTextView = (TextView)this.findViewById(R.id.view_chart_progress_title);
        this.titleTextView.setText((CharSequence)this.titleText);
        this.titleTextView.setTextColor(this.titleTextColor);
        this.titleTextView.setTextSize(0, this.titleTextSize);
        this.titleTextView.setTypeface(Typeface.create((String)this.titleTextTypeface, (int)0));
        this.finishView = (TextView)this.findViewById(R.id.view_chart_progress_finish);
        this.finishView.setText((CharSequence)this.finishText);
        this.finishView.setTextColor(this.finishTextColor);
        this.tabLayout = (TabLayout)this.findViewById(R.id.view_chart_progress_tabs);
        this.tabLayout.setSelectedTabIndicatorColor(this.tabIndicatorColor);
        this.tabLayout.setTabTextColors(this.tabTextColor, this.tabSelectedTextColor);
        this.chart = (PieChart)this.findViewById(R.id.view_chart_progress_chart);
        this.chart.setDrawSliceText(false);
        this.chart.setTouchEnabled(false);
        this.chart.setHoleColor(0);
        this.chart.setHoleRadius(95.0f);
        this.chart.getLegend().setEnabled(false);
        this.chart.setDescription("");
        this.chart.setCenterTextColor(this.centerTextColor);
        this.chart.setCenterTextSize(this.centerTextSize);
        this.chart.setCenterTextTypeface(Typeface.create((String)this.centerTextTypeface, (int)0));
    }

    public void setTitle(@StringRes int titleResId) {
        String title = this.getContext().getString(titleResId);
        this.setTitle(title);
    }

    public void setTitle(String title) {
        this.titleTextView.setText((CharSequence)title);
    }

    public void setFinishAction(Action1<Object> action) {
        this.finishView.setVisibility(action == null ? 8 : 0);
        if (this.finishSub != null) {
            this.finishSub.unsubscribe();
        }
        if (action != null) {
            this.finishSub = RxView.clicks((View)this.finishView).subscribe(action);
        }
    }

    public void setData(final List<PieData> dataSet) {
        this.tabLayout.removeAllTabs();
        int size = dataSet.size();
        for (int i = 0; i < size; ++i) {
            PieData data = dataSet.get(i);
            TabLayout.Tab newTab = this.tabLayout.newTab();
            newTab.setText((CharSequence)data.getDataSet().getLabel());
            newTab.setTag((Object)Float.valueOf(data.getDataSet().getEntryForIndex(0).getVal()));
            this.tabLayout.addTab(newTab, 0);
            if (i != size - 1) continue;
            this.post(ProgressChartCard$$Lambda$1.lambdaFactory$(this));
        }
        this.tabLayout.setOnTabSelectedListener((TabLayout.OnTabSelectedListener)new IconTabLayout.OnTabSelectedListenerAdapter(){

            @Override
            public void onTabSelected(TabLayout.Tab tab) {
                PieData data = (PieData)dataSet.get(tab.getPosition());
                float complete = data.getDataSet().getEntryForIndex(0).getVal();
                float incomplete = data.getDataSet().getEntryForIndex(1).getVal();
                ProgressChartCard.this.chart.setData((ChartData)data);
                ProgressChartCard.this.chart.setCenterText((CharSequence)String.format(ProgressChartCard.this.centerTextFormat, ProgressChartCard.this.numberFormat.format(complete), ProgressChartCard.this.numberFormat.format(complete + incomplete)));
                ProgressChartCard.this.chart.notifyDataSetChanged();
                ProgressChartCard.this.chart.invalidate();
            }

            @Override
            public void onTabReselected(TabLayout.Tab tab) {
                super.onTabReselected(tab);
                this.onTabSelected(tab);
            }
        });
    }

    public PieChart getChart() {
        return this.chart;
    }

    private /* synthetic */ void lambda$setData$0() {
        int lastIndex = this.tabLayout.getTabCount() - 1;
        int right = ((ViewGroup)this.tabLayout.getChildAt(0)).getChildAt(lastIndex).getRight();
        this.tabLayout.scrollTo(right, 0);
        this.tabLayout.getTabAt(lastIndex).select();
    }

    static /* synthetic */ void access$lambda$0(ProgressChartCard progressChartCard) {
        progressChartCard.lambda$setData$0();
    }
}

