/*
 * Decompiled with CFR 0.152.
 */
package org.researchstack.backbone.ui.graph;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.support.annotation.StringRes;
import android.support.v7.widget.CardView;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.github.mikephil.charting.charts.PieChart;
import com.github.mikephil.charting.data.ChartData;
import com.github.mikephil.charting.data.PieData;
import java.text.NumberFormat;
import org.researchstack.backbone.R;

public class PieChartCard
extends CardView {
    private TextView titleTextView;
    private PieChart chart;
    private LinearLayout rowContainer;
    private NumberFormat numberFormat;
    private int valueTextFormat;
    private String titleText;
    private int titleTextColor;
    private float titleTextSize;
    private String titleTextTypeface;

    public PieChartCard(Context context) {
        super(context);
        this.initializeRoot(null, R.attr.pieChartCardStyle);
        this.initializeViews();
    }

    public PieChartCard(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initializeRoot(attrs, R.attr.pieChartCardStyle);
        this.initializeViews();
    }

    public PieChartCard(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initializeRoot(attrs, defStyleAttr);
        this.initializeViews();
    }

    private void initializeRoot(AttributeSet attrs, int defStyleAttr) {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.rsb_view_chart_pie, (ViewGroup)this, true);
        this.numberFormat = NumberFormat.getInstance();
        this.numberFormat.setMinimumFractionDigits(0);
        this.numberFormat.setMaximumFractionDigits(2);
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.PieChartCard, defStyleAttr, R.style.Widget_Backbone_Chart_Pie);
        this.titleText = a.getString(R.styleable.PieChartCard_titleText);
        this.titleTextColor = a.getColor(R.styleable.PieChartCard_titleTextColor, 0);
        this.titleTextSize = a.getDimension(R.styleable.PieChartCard_titleTextSize, 0.0f);
        this.titleTextTypeface = a.getString(R.styleable.PieChartCard_titleTextTypeface);
        this.valueTextFormat = a.getResourceId(R.styleable.PieChartCard_valueTextFormat, 0);
        a.recycle();
    }

    private void initializeViews() {
        this.titleTextView = (TextView)this.findViewById(R.id.view_chart_pie_title);
        this.titleTextView.setText((CharSequence)this.titleText);
        this.titleTextView.setTextColor(this.titleTextColor);
        this.titleTextView.setTextSize(0, this.titleTextSize);
        this.titleTextView.setTypeface(Typeface.create((String)this.titleTextTypeface, (int)0));
        this.chart = (PieChart)this.findViewById(R.id.view_chart_pie);
        this.chart.setDrawSliceText(false);
        this.chart.setTouchEnabled(false);
        this.chart.setHoleRadius(0.0f);
        this.chart.setTransparentCircleRadius(0.0f);
        this.chart.getLegend().setEnabled(false);
        this.chart.setDescription("");
        this.chart.setDrawCenterText(false);
        this.rowContainer = (LinearLayout)this.findViewById(R.id.view_chart_pie_rows);
    }

    public void setTitle(@StringRes int titleResId) {
        String title = this.getContext().getString(titleResId);
        this.setTitle(title);
    }

    public void setTitle(String title) {
        this.titleTextView.setText((CharSequence)title);
    }

    public void setData(PieData data) {
        this.chart.setData((ChartData)data);
        this.chart.notifyDataSetChanged();
        this.chart.invalidate();
        this.rowContainer.removeAllViews();
        LayoutInflater inflater = LayoutInflater.from((Context)this.getContext());
        int size = data.getXVals().size();
        for (int i = 0; i < size; ++i) {
            String xVal = (String)data.getXVals().get(i);
            float entryValue = data.getDataSet().getEntryForIndex(i).getVal();
            View row = inflater.inflate(R.layout.rsb_item_chart_pie, (ViewGroup)this.rowContainer, false);
            TextView label = (TextView)row.findViewById(R.id.item_chart_pie_label);
            label.setText((CharSequence)xVal);
            label.setTextColor(data.getDataSet().getColor(i));
            TextView value = (TextView)row.findViewById(R.id.item_chart_pie_value);
            value.setText((CharSequence)this.getContext().getString(this.valueTextFormat, new Object[]{this.numberFormat.format(entryValue)}));
            value.setTextColor(data.getDataSet().getColor(i));
            this.rowContainer.addView(row);
        }
    }

    public PieChart getChart() {
        return this.chart;
    }
}

