/*
 * Decompiled with CFR 0.152.
 */
package org.researchstack.backbone.ui.graph;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.support.annotation.StringRes;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v7.widget.CardView;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.github.mikephil.charting.charts.LineChart;
import com.github.mikephil.charting.components.XAxis;
import com.github.mikephil.charting.components.YAxis;
import com.github.mikephil.charting.data.ChartData;
import com.github.mikephil.charting.data.LineData;
import com.jakewharton.rxbinding.view.RxView;
import org.researchstack.backbone.R;
import rx.Subscription;
import rx.functions.Action1;

public class LineChartCard
extends CardView {
    private TextView titleTextView;
    private ImageView expand;
    private Subscription expandSub;
    private LineChart chart;
    private String titleText;
    private int titleTextColor;
    private float titleTextSize;
    private String titleTextTypeface;
    private int chartXAxisTextColor;
    private float chartXAxisTextSize;
    private String chartXAxisTextTypeface;
    private int chartYAxisTextColor;
    private float chartYAxisTextSize;
    private String chartYAxisTextTypeface;
    private int expandTintColor;

    public LineChartCard(Context context) {
        super(context);
        this.initializeRoot(null, R.attr.lineChartCardStyle);
        this.initializeViews();
    }

    public LineChartCard(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initializeRoot(attrs, R.attr.lineChartCardStyle);
        this.initializeViews();
    }

    public LineChartCard(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initializeRoot(attrs, defStyleAttr);
        this.initializeViews();
    }

    private void initializeRoot(AttributeSet attrs, int defStyleAttr) {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.rsb_view_chart_line, (ViewGroup)this, true);
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.LineChartCard, defStyleAttr, R.style.Widget_Backbone_Chart_Line);
        this.titleText = a.getString(R.styleable.LineChartCard_titleText);
        this.titleTextColor = a.getColor(R.styleable.LineChartCard_titleTextColor, 0);
        this.titleTextSize = a.getDimension(R.styleable.LineChartCard_titleTextSize, 0.0f);
        this.titleTextTypeface = a.getString(R.styleable.LineChartCard_titleTextTypeface);
        this.chartXAxisTextColor = a.getColor(R.styleable.LineChartCard_chartXAxisTextColor, 0);
        this.chartXAxisTextSize = a.getDimension(R.styleable.LineChartCard_chartXAxisTextSize, 0.0f) / this.getResources().getDisplayMetrics().density;
        this.chartXAxisTextTypeface = a.getString(R.styleable.LineChartCard_chartXAxisTextTypeface);
        this.chartYAxisTextColor = a.getColor(R.styleable.LineChartCard_chartYAxisTextColor, 0);
        this.chartYAxisTextSize = a.getDimension(R.styleable.LineChartCard_chartYAxisTextSize, 0.0f) / this.getResources().getDisplayMetrics().density;
        this.chartYAxisTextTypeface = a.getString(R.styleable.LineChartCard_chartYAxisTextTypeface);
        this.expandTintColor = a.getColor(R.styleable.LineChartCard_expandTintColor, 0);
        a.recycle();
    }

    private void initializeViews() {
        this.titleTextView = (TextView)this.findViewById(R.id.view_chart_line_title);
        this.titleTextView.setText((CharSequence)this.titleText);
        this.titleTextView.setTextColor(this.titleTextColor);
        this.titleTextView.setTextSize(0, this.titleTextSize);
        this.titleTextView.setTypeface(Typeface.create((String)this.titleTextTypeface, (int)0));
        this.expand = (ImageView)this.findViewById(R.id.view_chart_line_expand);
        if (this.expandTintColor != 0) {
            Drawable drawable = this.expand.getDrawable();
            drawable = DrawableCompat.wrap((Drawable)drawable);
            DrawableCompat.setTint((Drawable)drawable, (int)this.expandTintColor);
            this.expand.setImageDrawable(drawable);
        }
        this.chart = (LineChart)this.findViewById(R.id.view_chart_line);
        this.chart.getLegend().setEnabled(false);
        this.chart.setDescription("");
        this.chart.setDrawBorders(false);
        this.chart.setDrawGridBackground(false);
        this.chart.setPinchZoom(false);
        this.chart.setTouchEnabled(true);
        this.chart.setDragEnabled(true);
        this.chart.setExtraLeftOffset(0.0f);
        this.chart.setExtraBottomOffset(8.0f);
        this.chart.setExtraTopOffset(0.0f);
        XAxis xAxis = this.chart.getXAxis();
        xAxis.setPosition(XAxis.XAxisPosition.BOTTOM);
        xAxis.setDrawAxisLine(false);
        xAxis.setDrawGridLines(false);
        xAxis.setLabelsToSkip(0);
        xAxis.setXOffset(16.0f);
        xAxis.setTextSize(this.chartXAxisTextSize);
        xAxis.setTextColor(this.chartXAxisTextColor);
        xAxis.setTypeface(Typeface.create((String)this.chartXAxisTextTypeface, (int)0));
        YAxis yAxisLeft = this.chart.getAxisLeft();
        yAxisLeft.setDrawAxisLine(false);
        yAxisLeft.setDrawGridLines(false);
        yAxisLeft.setDrawZeroLine(false);
        yAxisLeft.setDrawLabels(true);
        yAxisLeft.setShowOnlyMinMax(true);
        yAxisLeft.setXOffset(16.0f);
        yAxisLeft.setTextSize(this.chartYAxisTextSize);
        yAxisLeft.setTextColor(this.chartYAxisTextColor);
        yAxisLeft.setTypeface(Typeface.create((String)this.chartYAxisTextTypeface, (int)0));
        YAxis yAxisRight = this.chart.getAxisRight();
        yAxisRight.setDrawAxisLine(false);
        yAxisRight.setDrawGridLines(false);
        yAxisRight.setDrawZeroLine(false);
        yAxisRight.setDrawLabels(false);
        yAxisRight.setSpaceTop(0.0f);
    }

    public void setTitle(@StringRes int titleResId) {
        String title = this.getContext().getString(titleResId);
        this.setTitle(title);
    }

    public void setTitle(String title) {
        this.titleTextView.setText((CharSequence)title);
    }

    public void setExpandAction(Action1<Object> action) {
        this.expand.setVisibility(action == null ? 8 : 0);
        if (this.expandSub != null) {
            this.expandSub.unsubscribe();
        }
        if (action != null) {
            this.expandSub = RxView.clicks((View)this.expand).subscribe(action);
        }
    }

    public void setData(LineData data) {
        this.setData(data, 0, 0);
    }

    public void setData(LineData data, int viewportStart, int viewPortEnd) {
        float maxOffset = data.getYMax() + data.getYMax() * 0.05f;
        this.chart.setData((ChartData)data);
        this.chart.getAxisLeft().setAxisMaxValue(maxOffset);
        this.chart.getAxisRight().setAxisMaxValue(maxOffset);
        if (viewportStart != viewPortEnd) {
            this.chart.setVisibleXRange((float)viewportStart, (float)viewPortEnd);
        }
        this.chart.notifyDataSetChanged();
        this.chart.invalidate();
    }

    public LineChart getChart() {
        return this.chart;
    }
}

