/*
 * Decompiled with CFR 0.152.
 */
package org.researchstack.backbone.ui.graph;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.support.annotation.StringRes;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v7.widget.CardView;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.github.mikephil.charting.charts.BarChart;
import com.github.mikephil.charting.components.XAxis;
import com.github.mikephil.charting.components.YAxis;
import com.github.mikephil.charting.data.BarData;
import com.github.mikephil.charting.data.ChartData;
import com.jakewharton.rxbinding.view.RxView;
import org.researchstack.backbone.R;
import rx.Subscription;
import rx.functions.Action1;

public class BarChartCard
extends CardView {
    private TextView titleTextView;
    private ImageView expand;
    private Subscription expandSub;
    private BarChart chart;
    private String titleText;
    private int titleTextColor;
    private float titleTextSize;
    private String titleTextTypeface;
    private float chartXAxisTextSize;
    private int chartXAxisTextColor;
    private String chartXAxisTextTypeface;
    private int expandTintColor;

    public BarChartCard(Context context) {
        super(context);
        this.initializeRoot(null, R.attr.barChartCardStyle);
        this.initializeViews();
    }

    public BarChartCard(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initializeRoot(attrs, R.attr.barChartCardStyle);
        this.initializeViews();
    }

    public BarChartCard(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initializeRoot(attrs, defStyleAttr);
        this.initializeViews();
    }

    private void initializeRoot(AttributeSet attrs, int defStyleAttr) {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.rsb_view_chart_bar, (ViewGroup)this, true);
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.BarChartCard, defStyleAttr, R.style.Widget_Backbone_Chart_Bar);
        this.titleText = a.getString(R.styleable.BarChartCard_titleText);
        this.titleTextColor = a.getColor(R.styleable.BarChartCard_titleTextColor, 0);
        this.titleTextSize = a.getDimension(R.styleable.BarChartCard_titleTextSize, 0.0f);
        this.titleTextTypeface = a.getString(R.styleable.BarChartCard_titleTextTypeface);
        this.chartXAxisTextColor = a.getColor(R.styleable.BarChartCard_chartXAxisTextColor, 0);
        this.chartXAxisTextSize = a.getDimension(R.styleable.BarChartCard_chartXAxisTextSize, 0.0f) / this.getResources().getDisplayMetrics().density;
        this.chartXAxisTextTypeface = a.getString(R.styleable.BarChartCard_chartXAxisTextTypeface);
        this.expandTintColor = a.getColor(R.styleable.BarChartCard_expandTintColor, 0);
        a.recycle();
    }

    private void initializeViews() {
        this.titleTextView = (TextView)this.findViewById(R.id.view_chart_bar_title);
        this.titleTextView.setText((CharSequence)this.titleText);
        this.titleTextView.setTextColor(this.titleTextColor);
        this.titleTextView.setTextSize(0, this.titleTextSize);
        this.titleTextView.setTypeface(Typeface.create((String)this.titleTextTypeface, (int)0));
        this.expand = (ImageView)this.findViewById(R.id.view_chart_line_expand);
        if (this.expandTintColor != 0) {
            Drawable drawable = this.expand.getDrawable();
            drawable = DrawableCompat.wrap((Drawable)drawable);
            DrawableCompat.setTint((Drawable)drawable, (int)this.expandTintColor);
            this.expand.setImageDrawable(drawable);
        }
        this.chart = (BarChart)this.findViewById(R.id.view_chart_bar);
        this.chart.getLegend().setEnabled(false);
        this.chart.setDescription("");
        this.chart.setDrawBorders(false);
        this.chart.setDrawValueAboveBar(false);
        this.chart.setDrawGridBackground(false);
        this.chart.setDrawBarShadow(false);
        this.chart.setDrawHighlightArrow(false);
        this.chart.setPinchZoom(false);
        this.chart.setExtraLeftOffset(0.0f);
        this.chart.setExtraRightOffset(0.0f);
        this.chart.setExtraBottomOffset(8.0f);
        this.chart.setExtraTopOffset(0.0f);
        this.chart.setTouchEnabled(true);
        this.chart.setDragEnabled(true);
        XAxis xAxis = this.chart.getXAxis();
        xAxis.setPosition(XAxis.XAxisPosition.BOTTOM);
        xAxis.setDrawAxisLine(false);
        xAxis.setYOffset(16.0f);
        xAxis.setDrawGridLines(false);
        xAxis.setLabelsToSkip(0);
        xAxis.setTextSize(this.chartXAxisTextSize);
        xAxis.setTextColor(this.chartXAxisTextColor);
        xAxis.setTypeface(Typeface.create((String)this.chartXAxisTextTypeface, (int)0));
        YAxis yAxisLeft = this.chart.getAxisLeft();
        yAxisLeft.setDrawAxisLine(false);
        yAxisLeft.setDrawGridLines(false);
        yAxisLeft.setDrawZeroLine(false);
        yAxisLeft.setDrawLabels(false);
        YAxis yAxisRight = this.chart.getAxisRight();
        yAxisRight.setDrawAxisLine(false);
        yAxisRight.setDrawGridLines(false);
        yAxisRight.setDrawZeroLine(false);
        yAxisRight.setDrawLabels(false);
    }

    public void setTitle(@StringRes int titleResId) {
        String title = this.getContext().getString(titleResId);
        this.setTitle(title);
    }

    public void setTitle(String title) {
        this.titleTextView.setText((CharSequence)title);
    }

    public void setExpandAction(Action1<Object> action) {
        this.expand.setVisibility(action == null ? 8 : 0);
        if (this.expandSub != null) {
            this.expandSub.unsubscribe();
        }
        if (action != null) {
            this.expandSub = RxView.clicks((View)this.expand).subscribe(action);
        }
    }

    public void setData(BarData data, boolean stacked) {
        float maxOffset = data.getYMax() + data.getYMax() * 0.05f;
        this.chart.setData((ChartData)data);
        this.chart.getAxisLeft().setAxisMaxValue(maxOffset);
        this.chart.getAxisRight().setAxisMaxValue(maxOffset);
        this.chart.getXAxis().setYOffset(stacked ? 0.0f : 16.0f);
        this.chart.notifyDataSetChanged();
        this.chart.invalidate();
    }

    public BarChart getChart() {
        return this.chart;
    }
}

