/*
 * Decompiled with CFR 0.152.
 */
package org.researchstack.backbone.ui;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.view.MenuItem;
import org.researchstack.backbone.R;
import org.researchstack.backbone.ui.views.LocalWebView;
import org.researchstack.backbone.utils.ThemeUtils;

public class ViewWebDocumentActivity
extends AppCompatActivity {
    public static final String TAG = ViewWebDocumentActivity.class.getSimpleName();
    public static final String KEY_DOC_PATH = TAG + ".DOC_PATH";
    public static final String KEY_DOC_CONTENT = TAG + ".DOC_CONTENT";
    public static final String KEY_TITLE = TAG + ".TITLE";
    public static final String KEY_THEME = TAG + ".THEME";

    public static Intent newIntentForContent(Context context, String title, String htmlConent) {
        return ViewWebDocumentActivity.newIntentForContent(context, title, htmlConent, true);
    }

    public static Intent newIntentForContent(Context context, String title, String htmlConent, boolean useCallingTheme) {
        Intent intent = ViewWebDocumentActivity.newIntent(context, title, useCallingTheme);
        intent.putExtra(KEY_DOC_CONTENT, htmlConent);
        return intent;
    }

    public static Intent newIntentForPath(Context context, String title, String absDocPath) {
        return ViewWebDocumentActivity.newIntentForPath(context, title, absDocPath, true);
    }

    public static Intent newIntentForPath(Context context, String title, String absDocPath, boolean useCallingTheme) {
        Intent intent = ViewWebDocumentActivity.newIntent(context, title, useCallingTheme);
        intent.putExtra(KEY_DOC_PATH, absDocPath);
        return intent;
    }

    private static Intent newIntent(Context context, String title, boolean useCallingTheme) {
        int theme;
        Intent intent = new Intent(context, ViewWebDocumentActivity.class);
        intent.putExtra(KEY_TITLE, title);
        if (useCallingTheme && (theme = ThemeUtils.getTheme(context)) != 0) {
            intent.putExtra(KEY_THEME, ThemeUtils.getTheme(context));
        }
        return intent;
    }

    protected void onCreate(Bundle savedInstanceState) {
        if (this.getIntent() != null && this.getIntent().hasExtra(KEY_THEME)) {
            this.setTheme(this.getIntent().getIntExtra(KEY_THEME, 0));
        }
        super.onCreate(savedInstanceState);
        super.setContentView(R.layout.rsb_activity_web_document);
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.setSupportActionBar(toolbar);
        ActionBar actionBar = this.getSupportActionBar();
        actionBar.setDisplayHomeAsUpEnabled(true);
        if (this.getIntent().hasExtra(KEY_TITLE)) {
            String title = this.getIntent().getStringExtra(KEY_TITLE);
            actionBar.setTitle((CharSequence)title);
        }
        LocalWebView webView = (LocalWebView)this.findViewById(R.id.webview);
        if (this.getIntent().hasExtra(KEY_DOC_PATH)) {
            String docPath = this.getIntent().getStringExtra(KEY_DOC_PATH);
            webView.loadUrl(docPath);
        } else if (this.getIntent().hasExtra(KEY_DOC_CONTENT)) {
            String docContent = this.getIntent().getStringExtra(KEY_DOC_CONTENT);
            webView.loadDataWithBaseURL(null, docContent, "text/html", "UTF-8", null);
        }
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.onBackPressed();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }
}

